/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.deployment.planner.DeltaSpecificationBuilder;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.test.deployment.DeployitTester;
import com.xebialabs.deployit.test.support.CloudHostRegistry;
import com.xebialabs.deployit.test.support.DeployedItestChangeSet;
import com.xebialabs.deployit.test.support.ItestTopology;
import com.xebialabs.deployit.test.support.TestExecutionContext;
import com.xebialabs.deployit.test.support.TestUtils;
import com.xebialabs.overcast.host.CloudHost;
import com.xebialabs.overcast.host.CloudHostFactory;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jdom2.JDOMException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public abstract class DeployedItestBase {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private static final String DEPLOYED_ITEST_DIR = "deployed-test-scripts";
    private String description;
    private File deployedChangeSetXmlFile;
    protected ItestTopology topology;
    protected Container container;
    private static DeployitTester tester;
    protected DeployedItestChangeSet deployedChangeSet;
    private static TestExecutionContext context;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public DeployedItestBase(String description, File deployedChangeSetXmlFile, ItestTopology topology, Container container) {
        this.description = description;
        this.deployedChangeSetXmlFile = deployedChangeSetXmlFile;
        this.topology = topology;
        this.container = container;
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> getTargets() throws Exception {
        ArrayList<Object[]> constructorArgsList = new ArrayList<Object[]>();
        Map<String, ItestTopology> topologies = ItestTopology.load();
        for (File deployedItestFile : DeployedItestBase.getDeployedItestFiles()) {
            String desc = "Test " + deployedItestFile.getName() + " on ";
            for (ItestTopology topology : topologies.values()) {
                if (!ItestTopology.isItestEnabled(topology.getId(), topology.isEnabledByDefault())) continue;
                for (Container container : topology.getTargets()) {
                    constructorArgsList.add(new Object[]{desc + container, deployedItestFile, topology, container});
                }
            }
        }
        return constructorArgsList;
    }

    @Before
    public void takeCareOfVagrantImages() {
        CloudHost cloudHost = CloudHostFactory.getCloudHost((String)this.topology.getId());
        if (cloudHost != null) {
            CloudHostRegistry.getInstance().makeSureIsUp(cloudHost);
            CloudHostRegistry.getInstance().makeSureAllDownInTheEnd();
        }
    }

    @Before
    public void prepareDeployedChangeSet() throws JDOMException, IOException {
        this.deployedChangeSet = DeployedItestChangeSet.loadChangeSet(this.deployedChangeSetXmlFile, this.container, this.topology, this.folder);
    }

    @After
    public void clearInspectionContext() {
        context.clearInspectionContext();
    }

    @BeforeClass
    public static void setup() {
        tester = new DeployitTester();
        context = new TestExecutionContext(DeployedItestBase.class, tester.repository());
    }

    @AfterClass
    public static void tearDown() {
        context.destroy();
    }

    private static Iterable<File> getDeployedItestFiles() throws URISyntaxException, IOException {
        File deployedItestDir = DeployedItestBase.getDeployedItestDir();
        final List<String> enabledItests = DeployedItestBase.getEnabledItests();
        return Iterables.filter(Arrays.asList(deployedItestDir.listFiles()), (Predicate)new Predicate<File>(){

            public boolean apply(File input) {
                String name = input.getName();
                return name.endsWith(".xml") && (enabledItests.isEmpty() || enabledItests.contains(name));
            }
        });
    }

    private static File getDeployedItestDir() throws URISyntaxException {
        URL deployedItestDirUrl = Thread.currentThread().getContextClassLoader().getResource(DEPLOYED_ITEST_DIR);
        Preconditions.checkNotNull((Object)deployedItestDirUrl);
        return new File(deployedItestDirUrl.toURI());
    }

    private static List<String> getEnabledItests() throws URISyntaxException, IOException {
        File deployedItestDir = DeployedItestBase.getDeployedItestDir();
        File enabledItestsFile = new File(deployedItestDir, "enabled-itests");
        ArrayList enabledItests = Lists.newArrayList();
        if (enabledItestsFile.exists()) {
            ArrayList tests = Lists.newArrayList((Iterable)Iterables.filter((Iterable)Files.readLines((File)enabledItestsFile, (Charset)Charset.defaultCharset()), (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    return !input.startsWith("#");
                }
            }));
            enabledItests.addAll(tests);
        }
        return enabledItests;
    }

    @Test
    public void shouldCreateAndDestroyDeployed() throws Exception {
        Assume.assumeTrue((boolean)this.deployedChangeSet.hasDeployedsToCreate());
        if (this.deployedChangeSet.getTests().isEmpty()) {
            this.runSpecifiedTests(this.defaultTestsToRun());
        } else {
            this.runSpecifiedTests(this.deployedChangeSet.getTests());
        }
    }

    private void runSpecifiedTests(List<DeployedItestChangeSet.TestAction> tests) {
        System.out.println("\nTest plan to execute :");
        int count = 1;
        for (DeployedItestChangeSet.TestAction t : tests) {
            System.out.println(count++ + ") " + t.toString().toLowerCase());
        }
        count = 1;
        System.out.println("\nExecuting test plan...");
        for (DeployedItestChangeSet.TestAction t : tests) {
            System.out.println("\n" + count++ + ") " + (Object)((Object)t) + "\n");
            switch (t) {
                case VERIFYABSENCE: 
                case VERIFYDESTROY: {
                    this.assertDeployedsDoNotExist(this.deployedChangeSet.getDeployedsToCreate());
                    break;
                }
                case CREATE: {
                    this.createDeployeds(this.deployedChangeSet.getDeployedsToCreate());
                    break;
                }
                case VERIFYCREATE: {
                    this.assertDeployedsWereCreatedCorrectly(this.deployedChangeSet.getDeployedsToCreate());
                    break;
                }
                case MODIFY: {
                    if (this.deployedChangeSet.hasDeployedsToModify()) {
                        this.modifyDeployeds(this.deployedChangeSet);
                        break;
                    }
                    System.out.println("No modifications defined.");
                    break;
                }
                case VERIFYMODIFY: {
                    if (this.deployedChangeSet.hasDeployedsToModify()) {
                        this.assertDeployedsWereCreatedCorrectly(this.deployedChangeSet.getDeployedsToModify());
                        break;
                    }
                    System.out.println("No modifications to verify.");
                    break;
                }
                case DESTROY: {
                    this.destroyDeployeds(this.deployedChangeSet.getDeployedsToCreate());
                    break;
                }
            }
            context.clearInspectionContext();
        }
        System.out.println("Executing test plan complete.");
    }

    private List<DeployedItestChangeSet.TestAction> defaultTestsToRun() {
        ArrayList tests = Lists.newArrayList();
        if (this.shouldCheckDeployedsDoNotExistBeforeCreating()) {
            tests.add(DeployedItestChangeSet.TestAction.VERIFYABSENCE);
        }
        if (this.shouldCreateDeployed()) {
            tests.add(DeployedItestChangeSet.TestAction.CREATE);
        }
        if (this.shouldCheckDeployedsCreatedCorrectly()) {
            tests.add(DeployedItestChangeSet.TestAction.VERIFYCREATE);
        }
        if (this.shouldModifyDeployeds()) {
            tests.add(DeployedItestChangeSet.TestAction.MODIFY);
            if (this.shouldCheckDeployedsModifiedCorrectly()) {
                tests.add(DeployedItestChangeSet.TestAction.VERIFYMODIFY);
            }
        }
        if (this.shouldDestroyDeployeds()) {
            tests.add(DeployedItestChangeSet.TestAction.DESTROY);
        }
        if (this.shouldCheckDeployedsDoNotExistAfterDelete()) {
            tests.add(DeployedItestChangeSet.TestAction.VERIFYDESTROY);
        }
        return tests;
    }

    protected void createDeployeds(List<Deployed> deployeds) {
        DeltaSpecificationBuilder builder = new DeltaSpecificationBuilder().initial(TestUtils.createDeployedApplication(TestUtils.createDeploymentPackage("1.0", new Deployable[0]), com.xebialabs.platform.test.TestUtils.createEnvironment((Container[])new Container[]{this.container})));
        for (Deployed d : deployeds) {
            List validationErrors = DescriptorRegistry.getDescriptor((Type)d.getType()).validate((ConfigurationItem)d);
            if (validationErrors.isEmpty()) {
                builder.create(d);
                continue;
            }
            Assert.fail((String)("Deployed has validation errors: " + validationErrors));
        }
        DeltaSpecification spec = builder.build();
        List<Step> resolvedPlan = tester.resolvePlan(spec);
        StepExitCode result = DeployitTester.executePlan(resolvedPlan, context);
        MatcherAssert.assertThat((String)"Create deployed step failed", (Object)result, (Matcher)CoreMatchers.is((Object)StepExitCode.SUCCESS));
    }

    protected void modifyDeployeds(DeployedItestChangeSet deployedChangeSet) {
        DeltaSpecificationBuilder builder = new DeltaSpecificationBuilder().upgrade(TestUtils.createDeployedApplication(com.xebialabs.platform.test.TestUtils.createDeploymentPackage((String)"1.0", (Deployable[])new Deployable[0]), com.xebialabs.platform.test.TestUtils.createEnvironment((Container[])new Container[]{this.container})), TestUtils.createDeployedApplication(com.xebialabs.platform.test.TestUtils.createDeploymentPackage((String)"2.0", (Deployable[])new Deployable[0]), com.xebialabs.platform.test.TestUtils.createEnvironment((Container[])new Container[]{this.container})));
        for (Deployed d : deployedChangeSet.getDeployedsToModify()) {
            List validationErrors = DescriptorRegistry.getDescriptor((Type)d.getType()).validate((ConfigurationItem)d);
            if (validationErrors.isEmpty()) {
                builder.modify(deployedChangeSet.getDeployedToCreate(d.getName()), d);
                continue;
            }
            Assert.fail((String)("Deployed has validation errors: " + validationErrors));
        }
        DeltaSpecification spec = builder.build();
        List<Step> resolvedPlan = tester.resolvePlan(spec);
        StepExitCode result = DeployitTester.executePlan(resolvedPlan, context);
        MatcherAssert.assertThat((String)"Modify deployed step failed", (Object)result, (Matcher)CoreMatchers.is((Object)StepExitCode.SUCCESS));
    }

    protected void destroyDeployeds(List<Deployed> deployeds) {
        DeltaSpecificationBuilder builder = new DeltaSpecificationBuilder().undeploy(TestUtils.createDeployedApplication(TestUtils.createDeploymentPackage("1.0", new Deployable[0]), com.xebialabs.platform.test.TestUtils.createEnvironment((Container[])new Container[]{this.container})));
        for (Deployed d : deployeds) {
            builder.destroy(d);
        }
        DeltaSpecification spec = builder.build();
        List<Step> resolvedPlan = tester.resolvePlan(spec);
        StepExitCode result = DeployitTester.executePlan(resolvedPlan, context);
        MatcherAssert.assertThat((String)"Destroy deployed step failed", (Object)result, (Matcher)CoreMatchers.is((Object)StepExitCode.SUCCESS));
    }

    protected void assertDeployedsDoNotExist(List<Deployed> deployeds) {
        block3: {
            try {
                List<Deployed> actualDeployeds = this.inspectDeployeds(deployeds);
                if (actualDeployeds.size() > 0) {
                    Assert.fail((String)String.format("Unexpected deployeds [%s]", Joiner.on((String)",").join(actualDeployeds)));
                }
            }
            catch (RuntimeException e) {
                if (e.getMessage().contains("Step failed:") || e.getMessage().contains("CliScriptException")) break block3;
                throw e;
            }
        }
    }

    protected void assertDeployedsWereCreatedCorrectly(List<Deployed> expectedDeployeds) {
        List<Deployed> actualDeployeds = this.inspectDeployeds(expectedDeployeds);
        if (actualDeployeds.size() != expectedDeployeds.size()) {
            Assert.fail((String)String.format("Expected deployeds [%s] to exist, but only found [%s]", Joiner.on((String)",").join(expectedDeployeds), Joiner.on((String)",").join(actualDeployeds)));
        }
        for (Deployed expected : expectedDeployeds) {
            int i = actualDeployeds.indexOf(expected);
            Preconditions.checkArgument((i != -1 ? 1 : 0) != 0, (String)"Cannot find [%s] in list of existing deployeds", (Object[])new Object[]{expected});
            Deployed actual = actualDeployeds.get(i);
            this.assertDeployedWasCreatedCorrectly((ConfigurationItem)expected, (ConfigurationItem)actual);
        }
    }

    protected void assertDeployedWasCreatedCorrectly(ConfigurationItem expectedDeployed, ConfigurationItem actualDeployed) {
        MatcherAssert.assertThat((String)"Expected actualDeployed and expectedDeployed to be of the same type", (Object)actualDeployed.getType(), (Matcher)CoreMatchers.equalTo((Object)expectedDeployed.getType()));
        Descriptor dd = DescriptorRegistry.getDescriptor((Type)expectedDeployed.getType());
        block6: for (PropertyDescriptor pd : dd.getPropertyDescriptors()) {
            if (pd.isHidden() || pd.isPassword()) continue;
            switch (pd.getKind()) {
                case MAP_STRING_STRING: {
                    Map expectedMap = (Map)pd.get(expectedDeployed);
                    Map actualMap = (Map)pd.get(actualDeployed);
                    MatcherAssert.assertThat((String)String.format("Expected Map<String,String> property '%s' to be the same on CI '%s'", pd.getName(), expectedDeployed.getName()), (Object)actualMap, (Matcher)CoreMatchers.equalTo((Object)expectedMap));
                    break;
                }
                case SET_OF_STRING: {
                    MatcherAssert.assertThat((String)String.format("Expected Set<String> property '%s' to be the same on CI", pd.getName(), expectedDeployed.getName()), (Object)((Set)pd.get(actualDeployed)), (Matcher)CoreMatchers.equalTo((Object)((Set)pd.get(expectedDeployed))));
                    break;
                }
                case LIST_OF_CI: {
                    AbstractCollection expectedCis = Lists.newArrayList((Iterable)((List)pd.get(expectedDeployed)));
                    AbstractCollection actualCis = Lists.newArrayList((Iterable)((List)pd.get(actualDeployed)));
                    MatcherAssert.assertThat((String)String.format("Expected List<CI> property '%s' to be of the same size on CI '%s' expected: %s actual: %s", pd.getName(), expectedDeployed.getName(), pd.get(expectedDeployed), pd.get(actualDeployed)), (Object)actualCis.size(), (Matcher)CoreMatchers.equalTo((Object)expectedCis.size()));
                    Iterator expectedIterator = expectedCis.iterator();
                    Iterator actualIterator = actualCis.iterator();
                    while (actualIterator.hasNext() && expectedIterator.hasNext()) {
                        ConfigurationItem a = (ConfigurationItem)actualIterator.next();
                        ConfigurationItem e = (ConfigurationItem)expectedIterator.next();
                        this.assertDeployedWasCreatedCorrectly(e, a);
                    }
                    continue block6;
                }
                case SET_OF_CI: {
                    AbstractCollection expectedCis = Sets.newHashSet((Iterable)((Set)pd.get(expectedDeployed)));
                    AbstractCollection actualCis = Sets.newHashSet((Iterable)((Set)pd.get(actualDeployed)));
                    MatcherAssert.assertThat((String)String.format("Expected Set<CI> property '%s' on CI '%s' to be of the same size expected: %s actual: %s", pd.getName(), expectedDeployed.getName(), pd.get(expectedDeployed), pd.get(actualDeployed)), (Object)actualCis.size(), (Matcher)CoreMatchers.equalTo((Object)expectedCis.size()));
                    block8: for (ConfigurationItem e : expectedCis) {
                        for (ConfigurationItem a : actualCis) {
                            if (!a.getId().endsWith(e.getId())) continue;
                            this.assertDeployedWasCreatedCorrectly(e, a);
                            continue block8;
                        }
                        Assert.fail((String)String.format("Expected Set<CI> property '%s' on CI '%s' to have element '%s'", pd.getName(), expectedDeployed.getName(), e.getId()));
                    }
                    continue block6;
                }
                default: {
                    Object inspectedValue = pd.get(actualDeployed);
                    Object expectedValue = pd.get(expectedDeployed);
                    MatcherAssert.assertThat((String)String.format("Property '%s' on CI '%s' expected '%s' but was '%s'", pd.getName(), expectedDeployed.getName(), expectedValue, inspectedValue), (Object)inspectedValue, (Matcher)CoreMatchers.equalTo((Object)expectedValue));
                }
            }
        }
    }

    protected List<Deployed> inspectDeployeds(final List<Deployed> deployeds) {
        ArrayList typesToDiscover = Lists.newArrayList();
        typesToDiscover.addAll(this.deployedChangeSet.getAdditionalTypesToDiscover());
        typesToDiscover.addAll(Lists.transform(deployeds, (Function)new Function<Deployed, Type>(){

            public Type apply(Deployed input) {
                return input.getType();
            }
        }));
        List<Object> discovered = Lists.newArrayList();
        ConfigurationItem ciToPerformInspectionOn = this.getCiToPerformInspectionOn(typesToDiscover);
        if (ciToPerformInspectionOn != null) {
            discovered = tester.runInspectionTask(ciToPerformInspectionOn, context);
        } else {
            if (!this.deployedChangeSet.getAdditionalTypesToDiscover().isEmpty()) {
                throw new UnsupportedOperationException("The discovery of additional types is not supported using old style discovery.");
            }
            for (Deployed deployed : this.deployedChangeSet.cloneForInspection(deployeds)) {
                context.clearInspectionContext();
                List<ConfigurationItem> c = tester.runInspectionTask((ConfigurationItem)deployed, context);
                discovered.addAll(c);
            }
        }
        Iterable existingDeployeds = Iterables.filter((Iterable)discovered, (Predicate)new Predicate<ConfigurationItem>(){

            public boolean apply(ConfigurationItem input) {
                return input instanceof Deployed && deployeds.contains(input);
            }
        });
        return Lists.newArrayList((Iterable)existingDeployeds);
    }

    protected boolean shouldCheckDeployedsDoNotExistBeforeCreating() {
        return this.deployedChangeSet.getDeployMode() == DeployedItestChangeSet.DeployMode.CREATE;
    }

    protected boolean shouldCreateDeployed() {
        return true;
    }

    protected boolean shouldCheckDeployedsCreatedCorrectly() {
        return true;
    }

    protected boolean shouldCheckDeployedsModifiedCorrectly() {
        return true;
    }

    protected boolean shouldModifyDeployeds() {
        return true;
    }

    protected boolean shouldDestroyDeployeds() {
        return this.deployedChangeSet.getDeployMode() == DeployedItestChangeSet.DeployMode.CREATE;
    }

    protected boolean shouldCheckDeployedsDoNotExistAfterDelete() {
        return this.deployedChangeSet.getDeployMode() == DeployedItestChangeSet.DeployMode.CREATE;
    }

    protected ConfigurationItem getCiToPerformInspectionOn(List<Type> typesToDiscover) {
        return null;
    }

    static {
        LocalBooter.bootWithoutGlobalContext();
    }
}

