/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState2;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.test.repository.InMemoryRepository;
import com.xebialabs.deployit.test.support.TestInspectionContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExecutionContext
implements ExecutionContext {
    private final Logger logger;
    private final Map<String, Object> attributes = Maps.newHashMap();
    private TestInspectionContext inspectionContext = new TestInspectionContext();
    private Repository repository;

    public TestExecutionContext() {
        this((Repository)InMemoryRepository.REFERENCE.get());
    }

    public TestExecutionContext(Class<?> clazz) {
        this(clazz, (Repository)InMemoryRepository.REFERENCE.get());
    }

    public TestExecutionContext(Repository repository) {
        this.repository = repository;
        this.logger = LoggerFactory.getLogger(TestExecutionContext.class);
    }

    public TestExecutionContext(Class<?> clazz, Repository repository) {
        this.repository = repository;
        this.logger = LoggerFactory.getLogger(clazz);
    }

    public void logOutput(String output) {
        this.logger.info(output);
    }

    public void logError(String error) {
        this.logger.error(error);
    }

    public void logError(String error, Throwable t) {
        this.logger.error(error, t);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public TestInspectionContext getInspectionContext() {
        return this.inspectionContext;
    }

    public void clearInspectionContext() {
        this.inspectionContext = new TestInspectionContext();
    }

    public void destroy() {
        TaskExecutionStateEvent destroyEvent = new TaskExecutionStateEvent(){

            public TaskExecutionState2 previousState2() {
                return TaskExecutionState2.EXECUTING;
            }

            public TaskExecutionState2 currentState2() {
                return TaskExecutionState2.DONE;
            }

            public TaskExecutionState previousState() {
                return this.previousState2().toTaskExecutionState();
            }

            public TaskExecutionState currentState() {
                return this.currentState2().toTaskExecutionState();
            }

            public TaskWithSteps task() {
                return null;
            }
        };
        for (Object attr : this.attributes.values()) {
            if (!(attr instanceof ExecutionStateListener)) continue;
            ((ExecutionStateListener)attr).taskStateChanged(destroyEvent);
        }
        this.attributes.clear();
    }
}

