package com.xebialabs.deployit.test.task;

import java.util.List;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.test.deployment.DeployitTester;
import com.xebialabs.deployit.test.repository.InMemoryRepository;
import com.xebialabs.deployit.test.support.TestExecutionContext;

import static com.google.common.base.Preconditions.checkNotNull;

public class ControlTaskTester {

    private final Repository repository;

    public ControlTaskTester() {
        this(new InMemoryRepository());
    }

    public ControlTaskTester(Repository repository) {
        this.repository = repository;
    }

    /**
     * Executes all steps of non-parametrized control task on CI
     */
    public StepExitCode executeControlTask(ConfigurationItem ci, String task) {
        MethodDescriptor controlTask = checkNotNull(ci.getType().getDescriptor().getControlTask(task));
        return DeployitTester.executePlan((List<Step>)controlTask.invoke(ci), new TestExecutionContext(repository));
    }

    /**
     * Executes all steps of parametrized control task on CI
     */
    public StepExitCode executeControlTask(ConfigurationItem ci, String task, Parameters parameters) {
        MethodDescriptor controlTask = checkNotNull(ci.getType().getDescriptor().getControlTask(task));
        return DeployitTester.executePlan((List<Step>) controlTask.invoke(ci, parameters), new TestExecutionContext(repository));
    }

    /**
     * Returns a repository for observation
     */
    public Repository getRepository() {
        return repository;
    }
}
