package com.xebialabs.deployit.test.support;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.collect.Maps;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.test.repository.InMemoryRepository;

import static com.xebialabs.deployit.engine.api.execution.TaskExecutionState.DONE;

import static com.xebialabs.deployit.engine.api.execution.TaskExecutionState.EXECUTING;

public class TestExecutionContext implements ExecutionContext {

    private final Logger logger;
    private final Map<String, Object> attributes = Maps.newHashMap();
    private TestInspectionContext inspectionContext = new TestInspectionContext();
    private Repository repository;

    public TestExecutionContext() {
        this(InMemoryRepository.REFERENCE.get());
    }

    public TestExecutionContext(Class<?> clazz) {
        this(clazz, InMemoryRepository.REFERENCE.get());
    }

    public TestExecutionContext(Repository repository) {
        this.repository = repository;
        logger = LoggerFactory.getLogger(TestExecutionContext.class);
    }

    public TestExecutionContext(Class<?> clazz, Repository repository) {
        this.repository = repository;
        this.logger = LoggerFactory.getLogger(clazz);
    }

    @Override
    public void logOutput(String output) {
        logger.info(output);
    }

    @Override
    public void logError(String error) {
        logger.error(error);
    }

    @Override
    public void logError(String error, Throwable t) {
        logger.error(error, t);
    }

    @Override
    public Object getAttribute(String name) {
        return attributes.get(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        attributes.put(name, value);
    }

    @Override
    public Repository getRepository() {
        return repository;
    }

    @Override
    public TestInspectionContext getInspectionContext() {
        return inspectionContext;
    }

    public void clearInspectionContext() {
        inspectionContext = new TestInspectionContext();
    }

    public void destroy() {

        TaskExecutionStateEvent destroyEvent = new TaskExecutionStateEvent() {
            
            @Override
            public TaskExecutionState previousState() {
                return EXECUTING;
            }

            @Override
            public TaskExecutionState currentState() {
                return DONE;
            }

            @Override
            public TaskWithSteps task() {
                return null;
            }

        };

        for (Object attr : attributes.values()) {
            if (attr instanceof ExecutionStateListener) {
               ((ExecutionStateListener) (attr)).taskStateChanged(destroyEvent);
            }
        }

        attributes.clear();
    }
}
