/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.booter.local.utils.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.junit.rules.TemporaryFolder;

public final class TempArtifactUtils {
    private TempArtifactUtils() {
    }

    public static File createTempFolderWithArtifactFile(TemporaryFolder temporaryFolder, String folderName, String fileName, String artifactResource) throws IOException {
        File earFolder = temporaryFolder.newFolder(folderName);
        TempArtifactUtils.copyResourceToFile(artifactResource, new File(earFolder, fileName));
        return earFolder;
    }

    public static File createTempArtifactFile(TemporaryFolder temporaryFolder, String fileName, String artifactResource) throws IOException {
        return TempArtifactUtils.copyResourceToFile(artifactResource, temporaryFolder.newFile(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyResourceToFile(String artifactResource, File earFile) throws IOException {
        URL earURL = TempArtifactUtils.class.getClassLoader().getResource(artifactResource);
        if (earURL == null) {
            throw new RuntimeException(String.format("artifactResource [%s] not found", artifactResource));
        }
        InputStream from = earURL.openStream();
        FileOutputStream to = new FileOutputStream(earFile);
        try {
            ByteStreams.copy((InputStream)from, (OutputStream)to);
        }
        finally {
            Closeables.closeQuietly((Closeable)from);
            Closeables.closeQuietly((Closeable)to);
        }
        return earFile;
    }
}

