package com.xebialabs.deployit.itest.cloudhost;

import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;

import com.xebialabs.overcast.host.CloudHost;

/**
 * Used to 'transform' a CloudHostFuture and do additional processing before it is returned in the
 * {@link ItestHostLauncher#launch(String)} method. The returned function will be wrapped in a Future and executed.
 */
public interface CloudHostFutureTransformer {
    // note transform with AsyncFunc does not work, guava 13.0 bug?
    public Function<CloudHost, CloudHost> transform(ListenableFuture<CloudHost> host);
}
