/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.itest.cloudhost;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.xebialabs.deployit.itest.cloudhost.CloudHostFutureTransformer;
import com.xebialabs.overcast.host.CloudHost;
import com.xebialabs.overcast.host.CloudHostFactory;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItestHostLauncher {
    private static Logger LOG = LoggerFactory.getLogger(ItestHostLauncher.class);
    public static final String MDC_KEY = "ProvisionedVm";
    protected final ListeningExecutorService vmExecutor;
    protected final Map<String, ListenableFuture<CloudHost>> hostRegistry = Maps.newHashMap();
    protected List<CloudHostFutureTransformer> transformers = Lists.newArrayList();
    private static ItestHostLauncher singleton = null;

    public static synchronized ItestHostLauncher getInstance() {
        if (singleton != null) {
            return singleton;
        }
        singleton = new ItestHostLauncher();
        return singleton;
    }

    protected ItestHostLauncher() {
        this.vmExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
        this.addVirtualMachineShutdownHook();
    }

    public void addTransformer(CloudHostFutureTransformer transformer) {
        this.transformers.add(transformer);
    }

    public synchronized ListenableFuture<CloudHost> launch(final String host) {
        if (this.hostRegistry.containsKey(host)) {
            LOG.debug("Returning existing cloudhost for {}", (Object)host);
            return this.hostRegistry.get(host);
        }
        LOG.debug("launcher: submit future {}", (Object)host);
        ListenableFuture future = this.vmExecutor.submit((Callable)new Callable<CloudHost>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CloudHost call() throws Exception {
                try {
                    MDC.put((String)ItestHostLauncher.MDC_KEY, (String)new String(host));
                    LOG.info("itest host '{}' starting", (Object)host);
                    CloudHost cloudHost = CloudHostFactory.getCloudHost((String)host);
                    LOG.debug("itest host '{}' setup", (Object)host);
                    cloudHost.setup();
                    LOG.info("itest host '{}' started", (Object)host);
                    CloudHost cloudHost2 = cloudHost;
                    return cloudHost2;
                }
                finally {
                    MDC.remove((String)ItestHostLauncher.MDC_KEY);
                }
            }
        });
        LOG.debug("launcher: adding transformers {}", (Object)host);
        for (CloudHostFutureTransformer t : this.transformers) {
            future = Futures.transform((ListenableFuture)future, t.transform((ListenableFuture<CloudHost>)future));
        }
        LOG.debug("launcher: registering {}", (Object)host);
        this.hostRegistry.put(host, (ListenableFuture<CloudHost>)future);
        return future;
    }

    public synchronized ListenableFuture<CloudHost> getCloudHostFuture(String host) {
        LOG.debug("Looking up future for host {}", (Object)host);
        if (!this.hostRegistry.containsKey(host)) {
            throw new NoSuchElementException(String.format("No such host '%s' launch it first", host));
        }
        return this.hostRegistry.get(host);
    }

    public synchronized void shutdown() {
        LOG.info("Shutting down ItestHostLauncher");
        this.vmExecutor.shutdown();
        this.shutdownHosts();
    }

    public void addVirtualMachineShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LOG.debug("Shutdown hook: shutting down virtual machines");
                ItestHostLauncher.this.shutdown();
                LOG.debug("Shutdown hook: completed.");
            }
        });
    }

    private void shutdownHosts() {
        for (ListenableFuture<CloudHost> h : this.hostRegistry.values()) {
            try {
                CloudHost ch = (CloudHost)h.get();
                LOG.debug("Shutting down itest host '{}'", (Object)ch.getHostName());
                ch.teardown();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.debug("Shutting down Executor.");
            }
        }
    }
}

