package com.xebialabs.deployit.test.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.junit.rules.TemporaryFolder;
import com.google.common.io.ByteStreams;

public final class TempArtifactUtils {

    private TempArtifactUtils() {
    }

    public static File createTempFolderWithArtifactFile(TemporaryFolder temporaryFolder, String folderName, String fileName, String artifactResource) throws IOException {
        File earFolder = temporaryFolder.newFolder(folderName);
        copyResourceToFile(artifactResource, new File(earFolder, fileName));
        return earFolder;
    }

    public static File createTempArtifactFile(TemporaryFolder temporaryFolder, String fileName, String artifactResource) throws IOException {
        return copyResourceToFile(artifactResource, temporaryFolder.newFile(fileName));
    }

    public static File copyResourceToFile(final String artifactResource, final File earFile) throws IOException {
        URL earURL = TempArtifactUtils.class.getClassLoader().getResource(artifactResource);
        if (earURL == null) {
            throw new RuntimeException(String.format("artifactResource [%s] not found", artifactResource));
        }
        try (InputStream from = earURL.openStream();
             FileOutputStream to = new FileOutputStream(earFile)) {
            ByteStreams.copy(from, to);
        }
        return earFile;
    }
}
