/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.deployment;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.deployment.planner.CompositePlan;
import com.xebialabs.deployit.deployment.planner.PhasedPlan;
import com.xebialabs.deployit.deployment.planner.Plan;
import com.xebialabs.deployit.deployment.planner.PlanPhase;
import com.xebialabs.deployit.deployment.planner.SerialPlan;
import com.xebialabs.deployit.deployment.planner.StepPlan;
import java.util.ArrayList;
import java.util.List;

public class PlanUtils {
    public static List<StepPlan.StepWithPlanningInfo> flattenPlan(Plan plan) {
        ArrayList stepsWithDelta = Lists.newArrayList();
        if (plan instanceof PhasedPlan) {
            stepsWithDelta.addAll(FluentIterable.from((Iterable)((PhasedPlan)plan).phases()).transformAndConcat((Function)new Function<PlanPhase, Iterable<StepPlan.StepWithPlanningInfo>>(){

                public Iterable<StepPlan.StepWithPlanningInfo> apply(PlanPhase planPhase) {
                    return PlanUtils.flattenPlan((Plan)planPhase.plan());
                }
            }).toList());
        } else if (plan instanceof CompositePlan) {
            for (Plan subPlan : ((CompositePlan)plan).getSubPlans()) {
                if (subPlan instanceof StepPlan) {
                    stepsWithDelta.addAll(((StepPlan)subPlan).getStepsWithPlanningInfo());
                    continue;
                }
                if (subPlan instanceof CompositePlan) {
                    stepsWithDelta.addAll(PlanUtils.flattenPlan(subPlan));
                    continue;
                }
                throw new RuntimeException("Can not flatten " + subPlan.getClass().getSimpleName());
            }
        } else {
            stepsWithDelta.addAll(((StepPlan)plan).getStepsWithPlanningInfo());
        }
        return stepsWithDelta;
    }

    public static List<StepPlan.Checkpoint> resolveCheckpoints(Plan plan) {
        ArrayList checkpoints = Lists.newArrayList();
        if (plan instanceof PhasedPlan) {
            checkpoints.addAll(PlanUtils.resolveCheckpoints((Plan)((PlanPhase)((PhasedPlan)plan).phases().get(0)).plan()));
        } else if (plan instanceof SerialPlan) {
            for (Plan subPlan : ((SerialPlan)plan).getSubPlans()) {
                checkpoints.addAll(PlanUtils.resolveCheckpoints(subPlan));
            }
        } else if (plan instanceof StepPlan) {
            checkpoints.addAll(((StepPlan)plan).getCheckpoints());
        } else {
            throw new RuntimeException("Can not flatten " + plan.getClass().getSimpleName());
        }
        return checkpoints;
    }
}

