package com.xebialabs.deployit.test.deployment;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.xld.Domain;
import com.xebialabs.deployit.plugin.api.xld.DistributionVersion;

import static com.xebialabs.deployit.server.api.util.IdGenerator.generateId;

public class DeltaSpecifications {

    public static DeployedApplication createDeployedApplication(DistributionVersion version, Domain environment) {
        String id = generateId(environment.getId(), version.getDistribution().getId());
        DeployedApplication deployedApplication = Type.valueOf(DeployedApplication.class).getDescriptor().newInstance(id);
        deployedApplication.setVersion(version);
        deployedApplication.setEnvironment(environment);
        return deployedApplication;
    }

}
