/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.platform.test;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.overthere.local.LocalFile;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TestUtils {
    public static String readResource(String resource) throws IOException {
        return Resources.toString((URL)Resources.getResource((String)resource), (Charset)Charset.defaultCharset());
    }

    public static <T> T newInstance(String type) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((String)type);
        if (descriptor == null) {
            throw new RuntimeException("Cannot instantiate unknown type");
        }
        return (T)descriptor.newInstance();
    }

    public static <T> T newInstance(Class<T> clazz) {
        return TestUtils.newInstance(Type.valueOf(clazz).toString());
    }

    public static <T> T newInstance(Type type, String id) {
        return (T)type.getDescriptor().newInstance(id);
    }

    public static <T extends ConfigurationItem> T newInstance(Class<T> clazz, String id) {
        ConfigurationItem instance = (ConfigurationItem)TestUtils.newInstance(Type.valueOf(clazz).toString());
        instance.setId(id);
        return (T)instance;
    }

    public static <T extends ConfigurationItem> T newInstance(String type, String id) {
        ConfigurationItem instance = (ConfigurationItem)TestUtils.newInstance(type);
        instance.setId(id);
        return (T)instance;
    }

    public static String id(String ... names) {
        return Joiner.on((char)'/').join((Object[])names);
    }

    public static DeploymentPackage createDeploymentPackage(Deployable ... deployables) {
        return TestUtils.createDeploymentPackage("1.0", deployables);
    }

    public static DeploymentPackage createDeploymentPackage(String version, Deployable ... deployables) {
        Application app = TestUtils.newInstance(Application.class);
        app.setId(TestUtils.id("Applications", "Test"));
        DeploymentPackage pkg = TestUtils.newInstance(DeploymentPackage.class);
        pkg.setId(TestUtils.id(pkg.getId(), version));
        pkg.setApplication(app);
        for (Deployable deployable : deployables) {
            deployable.setId(TestUtils.id(app.getId(), deployable.getId()));
            pkg.addDeployable(deployable);
        }
        return pkg;
    }

    public static Environment createEnvironment(Container ... containers) {
        Environment env = TestUtils.newInstance(Environment.class);
        env.setId(TestUtils.id("Environments", "JUnit"));
        HashSet containerSet = Sets.newHashSet();
        containerSet.addAll(Arrays.asList(containers));
        env.setMembers((Set)containerSet);
        return env;
    }

    public static <T extends SourceArtifact> T createArtifact(String name, String version, String classpathResource, String type, File workingFolder) throws IOException {
        SourceArtifact artifact = (SourceArtifact)TestUtils.newInstance(type);
        artifact.setId(TestUtils.id("Applications", "Test", version, name));
        URL artifactURL = Thread.currentThread().getContextClassLoader().getResource(classpathResource);
        File artifactFile = new File(workingFolder, artifact.getName());
        artifactFile.createNewFile();
        Files.copy((InputSupplier)Resources.newInputStreamSupplier((URL)artifactURL), (File)artifactFile);
        artifact.setFile(LocalFile.valueOf((File)artifactFile));
        return (T)artifact;
    }

    public static <T extends SourceArtifact> T createArtifactWithoutCopy(String name, String version, String classpathResource, String type, File workingFolder) throws URISyntaxException {
        SourceArtifact artifact = (SourceArtifact)TestUtils.newInstance(type);
        artifact.setId(TestUtils.id("Applications", "Test", version, name));
        URL artifactURL = Thread.currentThread().getContextClassLoader().getResource(classpathResource);
        artifact.setFile(LocalFile.valueOf((File)new File(artifactURL.toURI().getPath())));
        return (T)artifact;
    }

    public static String getTitleFromHtmlPage(String url) throws IOException {
        return TestUtils.getTitleFromHtmlPage(new URL(url));
    }

    public static String getTitleFromHtmlPage(URL url) throws IOException {
        String htmlContent = TestUtils.getHtmlContentFromUrl(url);
        String title = "";
        Pattern p = Pattern.compile("<title>(.*?)</title>");
        Matcher m = p.matcher(htmlContent);
        while (m.find()) {
            title = m.group(1);
        }
        return title;
    }

    private static String getHtmlContentFromUrl(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        DataInputStream dis = new DataInputStream(urlConnection.getInputStream());
        String html = "";
        String tmp = "";
        while ((tmp = dis.readLine()) != null) {
            html = html + " " + tmp;
        }
        html = html.replaceAll("\\s+", " ");
        dis.close();
        return html;
    }
}

