/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.osb.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;

import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("serial")
@ConfigurationItem(description = "Oracle Service Bus Domain", category = "middleware")
public class OsbDomain extends WlsDomain {

	static final String OSB_WLST_PACKAGE = "com/xebialabs/deployit/plugin/osb";

	@ConfigurationItemProperty(required = true, description = "The location of the Oracle Service Bus.", size = Size.LARGE)
	private String osbHome;
	@ConfigurationItemProperty
	private OsbVersion version = OsbVersion.OSB_3_0;

	public String getOsbHome() {
		return osbHome;
	}

	public void setOsbHome(String osbHome) {
		this.osbHome = osbHome;
	}

	public OsbVersion getVersion() {
		return version;
	}

	public void setVersion(OsbVersion version) {
		this.version = version;
	}

	@Override
	public int executeWlstJythonScript(CommandExecutionCallbackHandler handler, HostSession s, String scriptPath, String... args) {
		List<String> cmd = new ArrayList<String>();

		switch (getActiveHost().getOperatingSystemFamily()) {
			case UNIX:
				logger.info("Uploading wlst.sh from Deployit distribution to add required libraries to the classpath.");
				HostFile uploadedWlstSh = s.copyToTemporaryFile(getWlstScript());
				cmd.add("/bin/sh");
				cmd.add(uploadedWlstSh.getPath());
				cmd.add(getWlHome());
				cmd.add(getOsbHome());
				break;
			case WINDOWS:
				logger.info("Uploading wlst.cmd from Deployit distribution to add required libraries to the classpath.");
				HostFile uploadedWlstCmd = s.copyToTemporaryFile(getWlstScript());
				cmd.add(uploadedWlstCmd.getPath());
				cmd.add(getWlHome());
				cmd.add(getOsbHome());
				break;
		}

		cmd.add("-i");
		cmd.add(scriptPath);
		for (String arg : args) {
			cmd.add(arg);
		}
		String[] cmdArray = cmd.toArray(new String[cmd.size()]);

		return s.execute(handler, cmdArray);
	}

	private ClassPathResource getWlstScript() {

		String shellName = "";
		switch (getActiveHost().getOperatingSystemFamily()) {
			case UNIX:
				shellName = "wlst.sh";
				break;
			case WINDOWS:
				shellName = "wlst.cmd";
				break;
		}

		String packageName = OSB_WLST_PACKAGE;
		switch (version) {
			case OSB_3_0:
				packageName += "/osb30/";
				break;
			case OSB_11g:
				packageName += "/osb11g/";
				break;

		}
		return new ClassPathResource(packageName + shellName);
	}

	private static Logger logger = Logger.getLogger(OsbDomain.class);
}
