#
# Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
#
# Your use of XebiaLabs Software and Documentation is subject to the Personal
# License Agreement.
#
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
#
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# "Documentation" means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

import sys, traceback
from java.io import File
from java.io import FileOutputStream
from java.util import Collections
from com.bea.wli.config import Ref


def deleteProject():
    try:
        # skip
        sys.argv.pop(0)
    
        user = sys.argv.pop(0)
        password = sys.argv.pop(0)
        url = sys.argv.pop(0)
        project = sys.argv.pop(0)
        
        if project == None :
            print "ERROR: No project specified"
            raise
        
        connectToServer(user, password, url)
        print 'connected'
        
        sessionName = createSessionName(project)
        print 'Created session', sessionName
        
        SessionMBean = getSessionMBean(sessionName)
        print 'SessionMBean started session'

        ALSBConfigurationMBean = findService(String("ALSBConfiguration.").concat(sessionName), "com.bea.wli.sb.management.configuration.ALSBConfigurationMBean")
        print "ALSBConfiguration MBean found", ALSBConfigurationMBean
        
        ref = Ref.makeProjectRef(project);
        print "Delete the project", project
        collection = Collections.singleton(ref)
        ALSBConfigurationMBean.delete(collection)
        
        print "Activating session %s" % (sessionName)
        SessionMBean.activateSession(sessionName, user)
        print "ALSB project "+ project + " has been deleted"

    except:
        print "ERROR: "
        exceptionType, exceptionValue, exceptionTraceback = sys.exc_info()
        print exceptionValue
        traceback.print_tb(exceptionTraceback, limit=1, file=sys.stdout)
        if SessionMBean != None:
            print "Discard Session %s" % (sessionName)
            SessionMBean.discardSession(sessionName)
        raise
        
#=======================================================================================
# Connect to the Admin Server
#=======================================================================================

def connectToServer(username, password, url):
    connect(username, password, url)
    domainRuntime()
    
#=======================================================================================
# Utility function to create an arbitrary session name
#=======================================================================================
def createSessionName(project):
    sessionName = String("DeployIt-Delete-"+str(project)+"-"+Long(System.currentTimeMillis()).toString())
    return sessionName

#=======================================================================================
# Utility function to load a session MBeans
#=======================================================================================
def getSessionMBean(sessionName):
    SessionMBean = findService("SessionManagement","com.bea.wli.sb.management.configuration.SessionManagementMBean")
    SessionMBean.createSession(sessionName)
    return SessionMBean

try:
    deleteProject()
except:
    print "ERROR: ", sys.exc_info()[0]
    dumpStack()
    disconnect()
    exit('y', 1)
    raise

disconnect()
exit()
