/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.osb.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.mapping.PlaceholderFormat;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileInputStreamTransformer;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.LenientTemplateResolvingHostFileInputTransformer;
import com.xebialabs.deployit.plugin.osb.ci.OsbJar;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.step.WlsStepBase;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportOsbConfigurationStep
extends WlsStepBase {
    static final String WLST_SCRIPT_DIRECTORY = "com/xebialabs/deployit/plugin/osb/step/";
    static final String DEPLOY_CONFIGURATION_ON_OSB_SCRIPT_NAME = "com/xebialabs/deployit/plugin/osb/step/import-osb-configuration-3.0.py";
    private static final String OSB_JAR_EXTENSION = ".jar";
    private String applicationLocation;
    private String applicationName;
    private String extension;
    private String project;
    private String customFile;
    protected Map<String, String> properties;
    protected PlaceholderFormat placeholderFormat;

    public ImportOsbConfigurationStep(WlsDomain domain, OsbJar application, String customFile, Map<String, String> properties, PlaceholderFormat placeholderFormat) {
        this(domain, application);
        this.customFile = customFile;
        this.properties = properties;
        this.placeholderFormat = placeholderFormat;
        if (properties == null || properties.isEmpty()) {
            this.setDescription("Import OSB Project " + this.project + " on " + domain + " using customization file ");
        } else {
            this.setDescription("Import OSB Project " + this.project + " on " + domain + " using customization file and properties replacement");
        }
    }

    public ImportOsbConfigurationStep(WlsDomain domain, OsbJar application) {
        super(domain);
        this.applicationLocation = application.getLocation();
        this.applicationName = application.getName();
        this.extension = OSB_JAR_EXTENSION;
        this.project = application.getProjectName();
        this.setDescription("Import OSB Project " + this.project + " on " + domain);
    }

    String getProject() {
        return this.project;
    }

    public String getCustomFile() {
        return this.customFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostFile uploadApplication(HostSession rhs) {
        HostSession lhs = Host.getLocalHost().getHostSession();
        try {
            HostFile applicationFileToUpload = lhs.getFile(this.applicationLocation);
            HostFile uploadedApplicationFile = rhs.getTempFile(this.applicationName, this.extension);
            HostFileUtils.copy((HostFile)applicationFileToUpload, (HostFile)uploadedApplicationFile);
            HostFile hostFile = uploadedApplicationFile;
            return hostFile;
        }
        finally {
            lhs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.domain.connectToAdminHost();
        try {
            String[] args;
            int res;
            HostFile uploadedApplication = this.uploadApplication(rhs);
            String uploadedApplicationPath = uploadedApplication.getPath().replace('\\', '/');
            ArrayList<String> argsList = new ArrayList<String>();
            argsList.add(this.domain.getUsername());
            argsList.add(this.domain.getPassword());
            argsList.add(this.domain.getConnectUrl());
            argsList.add(this.getProject());
            argsList.add(uploadedApplicationPath);
            if (this.getCustomFile() != null) {
                HostFile tempFile = rhs.getTempFile(this.applicationName, ".xml");
                HostSession localSession = Host.getLocalHost().getHostSession();
                try {
                    HostFileUtils.copyFile((HostFile)localSession.getFile(this.customFile), (HostFile)tempFile, (HostFileInputStreamTransformer)new LenientTemplateResolvingHostFileInputTransformer(this.properties, this.placeholderFormat));
                }
                finally {
                    localSession.close();
                }
                argsList.add(tempFile.getPath());
            }
            boolean bl = (res = this.executeWlstJythonScriptResource(ctx, rhs, DEPLOY_CONFIGURATION_ON_OSB_SCRIPT_NAME, args = argsList.toArray(new String[argsList.size()]))) == 0;
            return bl;
        }
        finally {
            rhs.close();
        }
    }
}

