/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.help;

import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class HelpScanner {
    private static final AtomicReference<Set<Class<?>>> discoveredCliObjects = new AtomicReference();

    public static void printHelp(Set<Class<?>> clazzes) {
        discoveredCliObjects.set(clazzes);
        HelpScanner.printHelp();
    }

    public static void printHelp() {
        System.out.println("Deployit Objects available on the CLI");
        System.out.println("To know more about a specific object, type <objectname>.help()");
        System.out.println("To get to know more about a specific method of an object, type <objectname>.help(\"<methodname>\")");
        System.out.println();
        for (Class<?> clazz : discoveredCliObjects.get()) {
            ClassHelp classHelp = clazz.getAnnotation(ClassHelp.class);
            CliObject cliObject = clazz.getAnnotation(CliObject.class);
            if (classHelp == null) continue;
            System.out.printf("%s: %s\n", cliObject.name(), classHelp.description());
        }
    }

    public static void printHelp(Class<?> clazz) {
        ClassHelp classHelp = clazz.getAnnotation(ClassHelp.class);
        CliObject cliObject = clazz.getAnnotation(CliObject.class);
        if (classHelp != null) {
            String objectName = cliObject.name();
            System.out.printf("%s: %s\n\n", objectName, classHelp.description());
            HelpScanner.printMethods(objectName, clazz);
            System.out.println();
        } else {
            System.out.println("Not found help for " + clazz);
        }
    }

    public static void printHelp(Class<?> clazz, String methodName) throws NoSuchMethodException {
        ClassHelp classHelp = clazz.getAnnotation(ClassHelp.class);
        CliObject cliObject = clazz.getAnnotation(CliObject.class);
        if (classHelp != null) {
            String objectName = cliObject.name();
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(methodName)) continue;
                HelpScanner.printMethod(objectName, method);
                HelpScanner.printMethodDetails(method);
                System.out.println();
            }
        }
    }

    private static void printMethodDetails(Method method) {
        MethodHelp methodHelp = method.getAnnotation(MethodHelp.class);
        if (methodHelp != null) {
            System.out.println(methodHelp.description());
            System.out.printf("Returns: %s - %s\n", method.getReturnType().getSimpleName(), methodHelp.returns());
            System.out.println();
            for (ParameterHelp parameterHelp : methodHelp.parameters()) {
                System.out.printf("%s: %s\n", parameterHelp.name(), parameterHelp.description());
            }
        }
    }

    private static void printMethods(String objectName, Class<?> clazz) {
        System.out.println("The methods available are:");
        for (Method method : clazz.getDeclaredMethods()) {
            HelpScanner.printMethod(objectName, method);
        }
    }

    private static void printMethod(String objectName, Method method) {
        MethodHelp methodHelp = method.getAnnotation(MethodHelp.class);
        if (methodHelp != null) {
            ParameterHelp[] parameterHelps;
            String methodName = method.getName();
            StringBuilder params = new StringBuilder();
            Class<?>[] classes = method.getParameterTypes();
            if (classes.length != (parameterHelps = methodHelp.parameters()).length) {
                throw new IllegalArgumentException("Not all parameters are documented!");
            }
            for (int i = 0; i < classes.length; ++i) {
                params.append(classes[i].getSimpleName());
                params.append(" ").append(parameterHelps[i].name());
                if (i >= classes.length - 1) continue;
                params.append(", ");
            }
            System.out.printf("%s.%s(%s) : %s\n", objectName, methodName, params, method.getReturnType().getSimpleName());
        }
    }
}

