/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.spi.CyclicBufferTracker;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyclicBufferTrackerImpl<E>
implements CyclicBufferTracker<E> {
    int bufferSize = 256;
    int maxNumBuffers = 64;
    int bufferCount = 0;
    static final int DELAY_BETWEEN_CLEARING_STALE_BUFFERS = 300000;
    private Map<String, Entry> map = new HashMap<String, Entry>();
    private Entry head;
    private Entry tail = this.head = new Entry(null, null, 0L);
    long lastCheck = 0L;

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void setBufferSize(int size) {
    }

    @Override
    public int getMaxNumberOfBuffers() {
        return this.maxNumBuffers;
    }

    @Override
    public void setMaxNumberOfBuffers(int maxNumBuffers) {
        this.maxNumBuffers = maxNumBuffers;
    }

    @Override
    public CyclicBuffer<E> get(String key, long timestamp) {
        Entry existing = this.map.get(key);
        if (existing == null) {
            CyclicBuffer<E> cb = this.processNewEntry(key, timestamp);
            return cb;
        }
        existing.setTimestamp(timestamp);
        this.moveToTail(existing);
        return existing.value;
    }

    private CyclicBuffer<E> processNewEntry(String key, long timestamp) {
        CyclicBuffer cb = new CyclicBuffer(this.bufferSize);
        Entry entry = new Entry(key, cb, timestamp);
        this.map.put(key, entry);
        ++this.bufferCount;
        this.rearrangeTailLinks(entry);
        if (this.bufferCount >= this.maxNumBuffers) {
            this.removeHead();
        }
        return cb;
    }

    private void removeHead() {
        CyclicBuffer cb = this.head.value;
        if (cb != null) {
            cb.clear();
        }
        this.map.remove(this.head.key);
        --this.bufferCount;
        this.head = this.head.next;
        this.head.prev = null;
    }

    private void moveToTail(Entry e) {
        this.rearrangePreexistingLinks(e);
        this.rearrangeTailLinks(e);
    }

    private void rearrangePreexistingLinks(Entry e) {
        if (e.prev != null) {
            e.prev.next = e.next;
        }
        if (e.next != null) {
            e.next.prev = e.prev;
        }
        if (this.head == e) {
            this.head = e.next;
        }
    }

    @Override
    public synchronized void clearStaleBuffers(long now) {
        if (this.lastCheck + 300000L > now) {
            return;
        }
        this.lastCheck = now;
        while (this.head.value != null && this.isEntryStale(this.head, now)) {
            CyclicBuffer cb = this.head.value;
            cb.clear();
            this.removeHead();
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    private final boolean isEntryStale(Entry entry, long now) {
        return entry.timestamp + 1800000L < now;
    }

    List<String> keyList() {
        LinkedList<String> result = new LinkedList<String>();
        Entry e = this.head;
        while (e != this.tail) {
            result.add(e.key);
            e = e.next;
        }
        return result;
    }

    private void rearrangeTailLinks(Entry e) {
        Entry preTail;
        if (this.head == this.tail) {
            this.head = e;
        }
        if ((preTail = this.tail.prev) != null) {
            preTail.next = e;
        }
        e.prev = preTail;
        e.next = this.tail;
        this.tail.prev = e;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry {
        Entry next;
        Entry prev;
        String key;
        CyclicBuffer<E> value;
        long timestamp;

        Entry(String k, CyclicBuffer<E> v, long timestamp) {
            this.key = k;
            this.value = v;
            this.timestamp = timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "(" + this.key + ", " + this.value + ")";
        }
    }
}

