/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core.executors;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.client.core.SelfExpandingBufferredInputStream;
import org.jboss.resteasy.client.core.executors.HttpClient4HeaderWrapper;
import org.jboss.resteasy.util.CaseInsensitiveMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheHttpClient4Executor
implements ClientExecutor {
    protected HttpClient httpClient;

    public ApacheHttpClient4Executor() {
        this.httpClient = new DefaultHttpClient();
    }

    public ApacheHttpClient4Executor(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public static CaseInsensitiveMap<String> extractHeaders(HttpResponse response) {
        CaseInsensitiveMap<String> headers = new CaseInsensitiveMap<String>();
        for (Header header : response.getAllHeaders()) {
            headers.add(header.getName(), header.getValue());
        }
        return headers;
    }

    @Override
    public ClientRequest createRequest(String uriTemplate) {
        return new ClientRequest(uriTemplate, (ClientExecutor)this);
    }

    @Override
    public ClientRequest createRequest(UriBuilder uriBuilder) {
        return new ClientRequest(uriBuilder, (ClientExecutor)this);
    }

    @Override
    public ClientResponse execute(ClientRequest request) throws Exception {
        String uri = request.getUri();
        HttpRequestBase httpMethod = this.createHttpMethod(uri, request.getHttpMethod());
        this.loadHttpMethod(request, httpMethod);
        final HttpResponse res = this.httpClient.execute((HttpUriRequest)httpMethod);
        BaseClientResponse response = new BaseClientResponse(new BaseClientResponse.BaseClientResponseStreamFactory(){
            InputStream stream;

            public InputStream getInputStream() throws IOException {
                if (this.stream == null) {
                    HttpEntity entity = res.getEntity();
                    if (entity == null) {
                        return null;
                    }
                    this.stream = new SelfExpandingBufferredInputStream(entity.getContent());
                }
                return this.stream;
            }

            public void performReleaseConnection() {
                try {
                    if (this.stream != null) {
                        this.stream.close();
                    } else {
                        InputStream is = this.getInputStream();
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, this);
        response.setStatus(res.getStatusLine().getStatusCode());
        response.setHeaders(ApacheHttpClient4Executor.extractHeaders(res));
        response.setProviderFactory(request.getProviderFactory());
        return response;
    }

    private HttpRequestBase createHttpMethod(String url, String restVerb) {
        if ("GET".equals(restVerb)) {
            return new HttpGet(url);
        }
        if ("POST".equals(restVerb)) {
            return new HttpPost(url);
        }
        if ("DELETE".equals(restVerb)) {
            return new HttpDelete(url);
        }
        final String verb = restVerb;
        return new HttpPost(url){

            public String getMethod() {
                return verb;
            }
        };
    }

    public void loadHttpMethod(final ClientRequest request, HttpRequestBase httpMethod) throws Exception {
        if (httpMethod instanceof HttpGet && request.followRedirects()) {
            HttpClientParams.setRedirecting((HttpParams)httpMethod.getParams(), (boolean)true);
        } else {
            HttpClientParams.setRedirecting((HttpParams)httpMethod.getParams(), (boolean)false);
        }
        if (request.getHeaders() != null) {
            for (Map.Entry header : request.getHeaders().entrySet()) {
                List values = (List)header.getValue();
                for (String value : values) {
                    httpMethod.addHeader((String)header.getKey(), value);
                }
            }
        }
        if (request.getBody() != null && !request.getFormParameters().isEmpty()) {
            throw new RuntimeException("You cannot send both form parameters and an entity body");
        }
        if (!request.getFormParameters().isEmpty()) {
            HttpPost post = (HttpPost)httpMethod;
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            for (Map.Entry formParam : request.getFormParameters().entrySet()) {
                List values = (List)formParam.getValue();
                for (String value : values) {
                    formparams.add(new BasicNameValuePair((String)formParam.getKey(), value));
                }
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formparams, "UTF-8");
            post.setEntity((HttpEntity)entity);
        }
        if (request.getBody() != null) {
            if (httpMethod instanceof HttpGet) {
                throw new RuntimeException("A GET request cannot have a body.");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                request.writeRequestBody(new HttpClient4HeaderWrapper(httpMethod, request.getProviderFactory()), baos);
                ByteArrayEntity entity = new ByteArrayEntity(baos.toByteArray()){

                    public Header getContentType() {
                        return new BasicHeader("Content-Type", request.getBodyContentType().toString());
                    }
                };
                HttpPost post = (HttpPost)httpMethod;
                post.setEntity((HttpEntity)entity);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

