/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import org.jboss.resteasy.plugins.server.servlet.HttpServletResponseHeaders;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServletResponseWrapper
implements HttpResponse {
    private HttpServletResponse response;
    private int status = 200;
    private MultivaluedMap<String, Object> outputHeaders;
    private ResteasyProviderFactory factory;

    public HttpServletResponseWrapper(HttpServletResponse response, ResteasyProviderFactory factory) {
        this.response = response;
        this.outputHeaders = new HttpServletResponseHeaders(response, factory);
        this.factory = factory;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
        this.response.setStatus(status);
    }

    @Override
    public MultivaluedMap<String, Object> getOutputHeaders() {
        return this.outputHeaders;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    @Override
    public void addNewCookie(NewCookie cookie) {
        Cookie cook = new Cookie(cookie.getName(), cookie.getValue());
        cook.setMaxAge(cookie.getMaxAge());
        cook.setVersion(cookie.getVersion());
        if (cookie.getDomain() != null) {
            cook.setDomain(cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            cook.setPath(cookie.getPath());
        }
        cook.setSecure(cookie.isSecure());
        if (cookie.getComment() != null) {
            cook.setComment(cookie.getComment());
        }
        this.response.addCookie(cook);
    }

    @Override
    public void sendError(int status) throws IOException {
        this.response.sendError(status);
    }

    @Override
    public void sendError(int status, String message) throws IOException {
        this.response.sendError(status, message);
    }

    @Override
    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    @Override
    public void reset() {
        this.response.reset();
        this.outputHeaders = new HttpServletResponseHeaders(this.response, this.factory);
    }
}

