/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.ssh.SshScpHostFile;
import com.xebialabs.deployit.hostsession.ssh.SshScpProtocolHelper;
import com.xebialabs.deployit.hostsession.ssh.SshSudoHostSession;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshScpOutputStream
extends OutputStream {
    protected SshScpHostFile file;
    protected long length;
    private SshScpProtocolHelper protocolHelper;
    private Logger logger = LoggerFactory.getLogger(SshScpOutputStream.class);

    SshScpOutputStream(SshScpHostFile file, long length) {
        this.file = file;
        this.length = length;
        this.protocolHelper = new SshScpProtocolHelper(file.sshHostSession, file.getPath());
    }

    void open() {
        try {
            this.protocolHelper.open("t");
            this.protocolHelper.readAck();
            this.protocolHelper.sendFilePreamble(this.file, this.length);
            this.logger.info("Opened SCP stream to write to remote file " + this.file);
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot open SCP stream to write remote file " + this.file, exc);
        }
    }

    public void write(byte[] b) throws IOException {
        this.protocolHelper.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.protocolHelper.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.protocolHelper.write(b);
    }

    public void close() {
        try {
            this.protocolHelper.sendAck();
            this.protocolHelper.readAck();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        int res = this.protocolHelper.close();
        if (res != 0) {
            throw new RuntimeIOException("Error closing SCP stream to write remote file " + this.file.remotePath + " (remote scp command returned error code " + res + ")");
        }
        this.chmodWrittenFile();
    }

    private void chmodWrittenFile() {
        if (this.file.sshHostSession instanceof SshSudoHostSession) {
            SshSudoHostSession sshSudoHostSession = (SshSudoHostSession)this.file.sshHostSession;
            CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
            int errno = sshSudoHostSession.noSudoExecute(capturedOutput, "chmod", "0666", this.file.remotePath);
            if (errno != 0) {
                throw new RuntimeIOException("Cannot chmod file " + this.file + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Chmodded file " + this.file);
            }
        }
    }
}

