/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileInputStreamTransformer;
import com.xebialabs.deployit.hostsession.ssh.SshScpDirectoryCopier;
import com.xebialabs.deployit.hostsession.ssh.SshScpHostFile;
import com.xebialabs.deployit.hostsession.ssh.SshSudoHostSession;
import com.xebialabs.deployit.hostsession.ssh.SshSudoOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSudoHostFile
extends SshScpHostFile
implements HostFile {
    private SshSudoHostSession sshSudoHostSession;
    private boolean isTempFile;
    private Logger logger = LoggerFactory.getLogger(SshSudoHostFile.class);

    public SshSudoHostFile(SshSudoHostSession session, String remotePath, boolean isTempFile) {
        super(session, remotePath);
        this.sshSudoHostSession = session;
        this.isTempFile = isTempFile;
    }

    protected int executeCommand(CommandExecutionCallbackHandler handler, String ... command) {
        if (this.isTempFile) {
            return this.sshSudoHostSession.noSudoExecute(handler, command);
        }
        return super.executeCommand(handler, command);
    }

    public HostFile getFile(String name) {
        SshSudoHostFile f = (SshSudoHostFile)super.getFile(name);
        f.isTempFile = this.isTempFile;
        return f;
    }

    public HostFile getParentFile() {
        SshSudoHostFile f = (SshSudoHostFile)super.getParentFile();
        f.isTempFile = this.isTempFile;
        return f;
    }

    public InputStream get() throws RuntimeIOException {
        if (this.isTempFile) {
            return super.get();
        }
        HostFile tempFile = this.getTempFile();
        this.copyHostFileToTempFile(tempFile);
        return tempFile.get();
    }

    private void copyHostFileToTempFile(HostFile tempFile) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Copying " + this + " to " + tempFile + " for reading");
        }
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int result = this.session.execute((CommandExecutionCallbackHandler)capturedOutput, "cp", this.getPath(), tempFile.getPath());
        if (result != 0) {
            String errorMessage = capturedOutput.getAll();
            throw new RuntimeIOException("Cannot copy " + this + " to " + tempFile + " for reading: " + errorMessage);
        }
    }

    public OutputStream put(long length) throws RuntimeIOException {
        if (this.isTempFile) {
            return super.put(length);
        }
        SshSudoOutputStream out = new SshSudoOutputStream(this, length, this.getTempFile());
        out.open();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Opened SUDO output stream to remote file " + this);
        }
        return out;
    }

    protected HostFile getTempFile() {
        String prefix = FilenameUtils.getBaseName((String)this.getPath());
        String suffix = FilenameUtils.getExtension((String)this.getPath());
        if (suffix.length() == 0) {
            suffix = null;
        }
        return this.sshSudoHostSession.getTempFile(prefix, suffix);
    }

    public void mkdir() throws RuntimeIOException {
        if (!this.isTempFile) {
            super.mkdir();
        } else {
            this.logger.debug("Making directory world-writable (with sticky bit)");
            this.mkdir(new String[]{"-m", "1777"});
        }
    }

    public void copyFrom(HostFile srcHostFile, HostFileInputStreamTransformer transformer) throws RuntimeIOException {
        if (srcHostFile.isDirectory()) {
            SshScpHostFile tempFile = (SshScpHostFile)this.getTempFile();
            SshScpDirectoryCopier dirCopier = new SshScpDirectoryCopier(srcHostFile, tempFile, transformer);
            dirCopier.startCopy();
            this.chmodWrittenFiles(tempFile);
            this.copyTempFileToHostFile(tempFile);
        } else {
            super.copyFrom(srcHostFile, transformer);
        }
    }

    private void chmodWrittenFiles(SshScpHostFile tempFile) {
        SshSudoHostSession sshSudoHostSession = (SshSudoHostSession)tempFile.sshHostSession;
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = sshSudoHostSession.noSudoExecute(capturedOutput, "chmod", "-R", "go+Xrw", tempFile.remotePath);
        if (errno != 0) {
            throw new RuntimeIOException("Cannot chmod file " + tempFile + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Chmodded file " + tempFile);
        }
    }

    private void copyTempFileToHostFile(SshScpHostFile tempFile) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Copying " + tempFile + " to " + this + " after writing");
        }
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int result = this.getSession().execute((CommandExecutionCallbackHandler)capturedOutput, "cp", "-r", tempFile.getPath(), this.getPath());
        if (result != 0) {
            String errorMessage = capturedOutput.getAll();
            throw new RuntimeIOException("Cannot copy " + tempFile + " to " + this + " after writing: " + errorMessage);
        }
    }
}

