/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.security.AuthenticationFailureException;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.security.UsernameAndPasswordCredentials;
import com.xebialabs.deployit.security.permission.Permission;
import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class JcrAuthenticationProvider
implements AuthenticationProvider {
    @Autowired
    private JcrTemplate jcrTemplate;
    private static final Logger logger = LoggerFactory.getLogger(JcrAuthenticationProvider.class);

    public Authentication authenticate(Authentication token) throws AuthenticationException {
        logger.info("Authenticating for Deployit: {}", token.getPrincipal());
        if (!(token instanceof UsernamePasswordAuthenticationToken)) {
            return null;
        }
        String username = ((UsernamePasswordAuthenticationToken)token).getPrincipal().toString();
        String password = ((UsernamePasswordAuthenticationToken)token).getCredentials().toString();
        this.checkPrincipalAndCredentialsWithJcr(username, password);
        return new UsernameAndPasswordCredentials(username, password);
    }

    private void checkPrincipalAndCredentialsWithJcr(String username, String password) {
        if (StringUtils.isBlank((String)username)) {
            throw new BadCredentialsException("Cannot authenticate with empty username");
        }
        try {
            this.jcrTemplate.execute(username, password, new JcrCallback<Object>(){

                @Override
                public Object doInJcr(Session session) throws IOException, RepositoryException {
                    return null;
                }
            });
            SecurityTemplate.executeAs(username, password, new SecurityCallback<Object>(){

                @Override
                public Object doAs() {
                    if (Permission.LOGIN.getPermissionHandler().hasPermission(Lists.newArrayList())) {
                        return null;
                    }
                    throw new AuthenticationFailureException("Login permission not granted.");
                }
            });
        }
        catch (AuthenticationFailureException exc) {
            throw new BadCredentialsException("Cannot authenticate " + username, (Throwable)exc);
        }
    }

    public boolean supports(Class<? extends Object> authentication) {
        return authentication.isAssignableFrom(UsernamePasswordAuthenticationToken.class);
    }
}

