/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PackageScanner {
    private static final Logger logger = LoggerFactory.getLogger(PackageScanner.class);

    PackageScanner() {
    }

    static Set<String> scan(File directory) {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("Directory " + directory.getAbsolutePath() + " does not exist or is not a directory");
        }
        HashSet result = Sets.newHashSet();
        if (logger.isDebugEnabled()) {
            logger.debug("Listing importable packages in " + directory.getAbsolutePath());
        }
        PackageScanner.scanDirectory(directory, result, "");
        if (logger.isDebugEnabled()) {
            logger.debug("Returning the following packages: " + result);
        }
        return result;
    }

    private static void scanDirectory(File directory, Set<String> result, String pathPrefix) {
        File[] files = directory.listFiles();
        if (logger.isDebugEnabled()) {
            logger.debug("Found " + files.length + " possible packages.");
        }
        for (File f : files) {
            if (PackageScanner.isExplodedPackage(f)) {
                result.add(pathPrefix + f.getName());
                continue;
            }
            if (PackageScanner.isDarPackage(f)) {
                result.add(pathPrefix + f.getName());
                continue;
            }
            if (!f.isDirectory()) continue;
            PackageScanner.scanDirectory(f, result, pathPrefix + f.getName() + "/");
        }
    }

    static boolean isDarPackage(File f) {
        return f.isFile() && StringUtils.endsWithIgnoreCase((String)f.getName(), (String)".dar");
    }

    static boolean isExplodedPackage(File f) {
        if (f.isDirectory()) {
            File manifestFile = PackageScanner.getManifestFileForUnpackedPackage(f);
            return manifestFile.exists();
        }
        return false;
    }

    static File getManifestFileForUnpackedPackage(File f) {
        File manifestFile = new File(new File(f, "META-INF"), "MANIFEST.MF");
        return manifestFile;
    }
}

