/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.ConfigurationItemRoot;
import com.xebialabs.deployit.ci.Application;
import com.xebialabs.deployit.ci.DeploymentPackage;
import com.xebialabs.deployit.ci.MiddlewareResource;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.repository.ArtifactEntity;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.service.importer.DeployableArtifactImporter;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemDescriptorRepositoryHolder;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemTypeDescriptorRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnpackedPackageManifestImporter {
    public static final String PACKAGE_FORMAT_VERSION_ATTRIBUTE_NAME = "Deployit-Package-Format-Version";
    public static final String PACKAGE_FORMAT_VERSION_NUMBER = "1.2";
    public static final String APPLICATION_ATTRIBUTE_NAME = "CI-Application";
    public static final String VERSION_ATTRIBUTE_NAME = "CI-Version";
    public static final String TYPE_ATTRIBUTE_NAME = "CI-Type";
    public static final String NAME_ATTRIBUTE_NAME = "CI-Name";
    public static final String NAMESPACE_SEPARATOR = "/";
    private static final String CI = "CI-";
    private static final Logger logger = LoggerFactory.getLogger(UnpackedPackageManifestImporter.class);

    public static Manifest readManifest(File manifestFile) {
        Manifest manifest;
        FileInputStream in = null;
        try {
            in = new FileInputStream(manifestFile);
            manifest = new Manifest(in);
        }
        catch (IOException exception) {
            try {
                throw new RuntimeIOException("Cannot read manifest file " + manifestFile, (Throwable)exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return manifest;
    }

    public static ConfigurationItemEntity createApplicationEntity(Manifest manifest) {
        Attributes mainAttributes = manifest.getMainAttributes();
        UnpackedPackageManifestImporter.verifyPackageFormatVersion(mainAttributes);
        ConfigurationItemEntity applicationEntity = new ConfigurationItemEntity(Application.class.getName());
        applicationEntity.setId(ConfigurationItemRoot.APPLICATIONS, UnpackedPackageManifestImporter.getApplicationName(manifest));
        return applicationEntity;
    }

    public static ConfigurationItemEntity createDeploymentPackageEntity(Manifest manifest, ConfigurationItemEntity applicationEntity) {
        Attributes mainAttributes = manifest.getMainAttributes();
        UnpackedPackageManifestImporter.verifyPackageFormatVersion(mainAttributes);
        String packageVersion = UnpackedPackageManifestImporter.getApplicationVersion(manifest);
        ConfigurationItemEntity deploymentPackageEntity = new ConfigurationItemEntity(DeploymentPackage.class.getName());
        deploymentPackageEntity.setId(applicationEntity.getId(), packageVersion);
        deploymentPackageEntity.addValue("version", packageVersion);
        return deploymentPackageEntity;
    }

    protected static String getApplicationName(Manifest manifest) {
        return UnpackedPackageManifestImporter.getAttribute(manifest, APPLICATION_ATTRIBUTE_NAME);
    }

    protected static String getApplicationVersion(Manifest manifest) {
        return UnpackedPackageManifestImporter.getAttribute(manifest, VERSION_ATTRIBUTE_NAME);
    }

    private static String getAttribute(Manifest manifest, String attributeName) {
        String attributeValue = StringUtils.trim((String)manifest.getMainAttributes().getValue(attributeName));
        if (StringUtils.isBlank((String)attributeValue)) {
            throw new ImporterException("Deployment package does not declare the " + attributeName + " main attribute", new Object[0]);
        }
        return attributeValue;
    }

    protected static void verifyPackageFormatVersion(Attributes mainAttributes) {
        String packageFormatVersion = StringUtils.trim((String)mainAttributes.getValue(PACKAGE_FORMAT_VERSION_ATTRIBUTE_NAME));
        if (packageFormatVersion == null) {
            packageFormatVersion = "unspecified";
        }
        if (!PACKAGE_FORMAT_VERSION_NUMBER.equals(packageFormatVersion)) {
            throw new ImporterException("Deployment package does not have the right Deployit-Package-Format-Version header value (actual: " + packageFormatVersion + " expected: " + PACKAGE_FORMAT_VERSION_NUMBER + ")", new Object[0]);
        }
    }

    public static boolean isMiddlewareResource(Map.Entry<String, Attributes> entry) {
        String configurationItemTypeShortName = StringUtils.trim((String)entry.getValue().getValue(TYPE_ATTRIBUTE_NAME));
        String entryName = StringUtils.trim((String)entry.getKey());
        if (configurationItemTypeShortName == null) {
            return false;
        }
        ConfigurationItemDescriptor configurationItemDescriptor = UnpackedPackageManifestImporter.getDescriptorForConfigurationItemShortName(entryName, configurationItemTypeShortName);
        return configurationItemDescriptor.getInterfaces().contains(MiddlewareResource.class.getName());
    }

    public static ArtifactEntity createArtifactEntity(ConfigurationItemEntity configurationItem, File packageToImportFile, Map.Entry<String, Attributes> entry, List<DeployableArtifactImporter> artifactImporters) {
        String entryName = StringUtils.trim((String)entry.getKey());
        Attributes entryAttributes = entry.getValue();
        String configurationItemTypeShortName = UnpackedPackageManifestImporter.readCIShortType(entryAttributes, entryName);
        ConfigurationItemDescriptor configurationItemDescriptor = UnpackedPackageManifestImporter.getDescriptorForConfigurationItemShortName(entryName, configurationItemTypeShortName);
        ArtifactEntity artifact = new ArtifactEntity(configurationItemDescriptor.getType());
        String baseId = configurationItem.getId();
        artifact.setId(baseId, UnpackedPackageManifestImporter.extractArtifactNameFromPath(entryName));
        artifact.addValue("location", "jcr://" + artifact.getId());
        File artifactFile = new File(packageToImportFile, entryName);
        for (DeployableArtifactImporter importer : artifactImporters) {
            if (!importer.canHandle(configurationItemDescriptor)) continue;
            importer.importArtifact(artifact, artifactFile, configurationItemDescriptor);
        }
        UnpackedPackageManifestImporter.fillAttributes(artifact, configurationItemDescriptor, entryAttributes, baseId);
        return artifact;
    }

    private static String extractArtifactNameFromPath(String path) {
        int index = path.lastIndexOf(NAMESPACE_SEPARATOR);
        if (index > -1) {
            if (++index >= path.length()) {
                throw new ImporterException("Could not determine artifact Name: %s because entry ends with '/'", path);
            }
            return path.substring(index);
        }
        return path;
    }

    private static String readCIShortType(Attributes entryAttributes, String entryName) {
        String configurationItemTypeShortName = StringUtils.trim((String)entryAttributes.getValue(TYPE_ATTRIBUTE_NAME));
        if (configurationItemTypeShortName == null) {
            throw new ImporterException("Could not import Name: %s because of missing %s entry in MANIFEST.MF", entryName, TYPE_ATTRIBUTE_NAME);
        }
        return configurationItemTypeShortName;
    }

    private static ConfigurationItemDescriptor getDescriptorForConfigurationItemShortName(String entryName, String configurationItemTypeShortName) {
        ConfigurationItemTypeDescriptorRepository typeDescriptorRepository = ConfigurationItemDescriptorRepositoryHolder.getDescriptorRepository();
        ConfigurationItemDescriptor configurationItemDescriptor = typeDescriptorRepository.getDescriptorByShortName(configurationItemTypeShortName);
        if (configurationItemDescriptor == null) {
            throw new ImporterException("Could not import Name: %s because %s is not a known CI type", entryName, configurationItemTypeShortName);
        }
        return configurationItemDescriptor;
    }

    public static ConfigurationItemEntity createMiddlewareResourceEntity(ConfigurationItemEntity deploymentPackage, File explodedPackage, Map.Entry<String, Attributes> entry) {
        String entryName = StringUtils.trim((String)entry.getKey());
        Attributes entryAttributes = entry.getValue();
        String configurationItemTypeShortName = UnpackedPackageManifestImporter.readCIShortType(entryAttributes, entryName);
        ConfigurationItemDescriptor configurationItemDescriptor = UnpackedPackageManifestImporter.getDescriptorForConfigurationItemShortName(entryName, configurationItemTypeShortName);
        ConfigurationItemEntity resource = new ConfigurationItemEntity(configurationItemDescriptor.getType());
        String baseId = deploymentPackage.getId();
        resource.setId(baseId, UnpackedPackageManifestImporter.extractArtifactNameFromPath(entryName));
        UnpackedPackageManifestImporter.fillAttributes(resource, configurationItemDescriptor, entryAttributes, baseId);
        return resource;
    }

    private static void fillAttributes(ConfigurationItemEntity entity, ConfigurationItemDescriptor configurationItemDescriptor, Attributes entryAttributes, final String baseId) {
        block7: for (ConfigurationItemPropertyDescriptor propertyDescriptor : configurationItemDescriptor.getPropertyDescriptors()) {
            String name = propertyDescriptor.getName();
            switch (propertyDescriptor.getType()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    String value = entryAttributes.getValue(CI + name);
                    if (value == null) continue block7;
                    entity.addValue(name, value);
                    continue block7;
                }
                case CI: {
                    String ci = entryAttributes.getValue(CI + name);
                    if (ci == null) continue block7;
                    entity.addValue(name, baseId + NAMESPACE_SEPARATOR + ci);
                    continue block7;
                }
                case LIST_OF_OBJECTS: {
                    List<Map<String, String>> objects = UnpackedPackageManifestImporter.handleListOfObjects(propertyDescriptor, entryAttributes);
                    if (objects.isEmpty()) continue block7;
                    entity.addValue(name, objects);
                    continue block7;
                }
                case SET_OF_STRINGS: {
                    Set<String> strings = UnpackedPackageManifestImporter.handleSetOfStrings(propertyDescriptor, entryAttributes);
                    if (strings.isEmpty()) continue block7;
                    entity.addValue(name, strings);
                    continue block7;
                }
                case SET_OF_CIS: {
                    HashSet cis = new HashSet(Collections2.transform(UnpackedPackageManifestImporter.handleSetOfStrings(propertyDescriptor, entryAttributes), (Function)new Function<String, String>(){

                        public String apply(String from) {
                            return baseId + UnpackedPackageManifestImporter.NAMESPACE_SEPARATOR + from;
                        }
                    }));
                    if (cis.isEmpty()) continue block7;
                    entity.addValue(name, cis);
                }
            }
        }
    }

    private static Set<String> handleSetOfStrings(ConfigurationItemPropertyDescriptor propertyDescriptor, Attributes entryAttributes) {
        String key = CI + propertyDescriptor.getName() + "-EntryValue";
        HashSet strings = Sets.newHashSet();
        for (Map.Entry<Object, Object> entry : entryAttributes.entrySet()) {
            if (!entry.getKey().toString().trim().startsWith(key)) continue;
            strings.add(entry.getValue().toString().trim());
        }
        return strings;
    }

    private static List<Map<String, String>> handleListOfObjects(ConfigurationItemPropertyDescriptor propertyDescriptor, Attributes entryAttributes) {
        String name = CI + propertyDescriptor.getName() + "-Entry";
        ArrayList objects = Lists.newArrayList();
        Map<String, Map<String, String>> keyValues = UnpackedPackageManifestImporter.gatherObjectEntriesFromAttributes(entryAttributes, name);
        for (String key : new TreeSet<String>(keyValues.keySet())) {
            ConfigurationItemPropertyDescriptor[] listObjectDescriptors;
            Map<String, String> values = keyValues.get(key);
            HashMap object = Maps.newHashMap();
            for (ConfigurationItemPropertyDescriptor listObjectDescriptor : listObjectDescriptors = propertyDescriptor.getListObjectPropertyDescriptors()) {
                String descriptorName = listObjectDescriptor.getName();
                if (values.get(descriptorName) == null) continue;
                object.put(descriptorName, values.get(descriptorName));
            }
            if (object.size() <= 0) continue;
            objects.add(object);
        }
        return objects;
    }

    private static Map<String, Map<String, String>> gatherObjectEntriesFromAttributes(Attributes entryAttributes, String name) {
        LinkedHashMap keyValues = Maps.newLinkedHashMap();
        for (Map.Entry<Object, Object> entry : entryAttributes.entrySet()) {
            String key = entry.getKey().toString().trim();
            if (!key.startsWith(name) || entryAttributes.getValue(key) == null) continue;
            String entryKey = key.substring(name.length());
            String entryNumber = entryKey.substring(entryKey.indexOf(45) + 1);
            entryKey = StringUtils.uncapitalize((String)entryKey.substring(0, entryKey.indexOf(45)));
            Map properties = (Map)keyValues.get(entryNumber);
            if (properties == null) {
                properties = Maps.newHashMap();
                keyValues.put(entryNumber, properties);
            }
            String entryValue = ((String)entry.getValue()).trim();
            properties.put(entryKey, entryValue);
        }
        return keyValues;
    }
}

