/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.deployment;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.DeploymentPackage;
import com.xebialabs.deployit.ci.Environment;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.security.UsernameAndPasswordCredentials;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.task.Task;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialDeploymentTask
extends Task {
    private final ConfigurationItemEntity sourceEntity;
    private final ConfigurationItemEntity targetEntity;
    private final Collection<ConfigurationItemEntity> mappingEntities;
    private Logger logger = LoggerFactory.getLogger(InitialDeploymentTask.class);

    public InitialDeploymentTask(ConfigurationItemEntity sourceEntity, ConfigurationItemEntity targetEntity, Collection<ConfigurationItemEntity> mappingEntities, List<Step> steps, RepositoryService repositoryService, PojoConverter pojoConverter, PojoConverter.Context ... pojoConverterContexts) {
        super(steps, repositoryService, pojoConverter, pojoConverterContexts);
        this.sourceEntity = sourceEntity;
        this.targetEntity = targetEntity;
        this.mappingEntities = mappingEntities;
    }

    @Override
    public void doAfterTaskStateChangedToDone() {
        UsernameAndPasswordCredentials owner = this.getOwnerCredentials();
        SecurityTemplate.executeAs(owner.getUsername(), owner.getPassword(), new SecurityCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object doAs() {
                PojoConverter.Context context = InitialDeploymentTask.this.pojoConverter.getContext();
                try {
                    DeploymentPackage pkg = (DeploymentPackage)context.toPojo(InitialDeploymentTask.this.sourceEntity);
                    Environment env = (Environment)context.toPojo(InitialDeploymentTask.this.targetEntity);
                    Deployment newDeployment = new Deployment(pkg, env);
                    String baseDeploymentLabel = DeploymentService.generateDeploymentLabel(pkg, env);
                    int i = 0;
                    while (true) {
                        if (i == 0) {
                            newDeployment.setLabel(baseDeploymentLabel);
                        } else {
                            newDeployment.setLabel(baseDeploymentLabel + " (" + i + ")");
                        }
                        try {
                            InitialDeploymentTask.this.repositoryService.create(new ConfigurationItemEntity[]{context.toEntity(newDeployment)});
                        }
                        catch (ItemAlreadyExistsException exc) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                    InitialDeploymentTask.this.logger.debug("Saved deployment with label " + newDeployment.getLabel());
                    for (ConfigurationItemEntity each : InitialDeploymentTask.this.mappingEntities) {
                        String mappingId = each.getId();
                        int i2 = 0;
                        while (true) {
                            if (i2 != 0) {
                                each.setId(mappingId + " (" + i2 + ")");
                            }
                            try {
                                InitialDeploymentTask.this.repositoryService.create(new ConfigurationItemEntity[]{each});
                            }
                            catch (ItemAlreadyExistsException exc) {
                                ++i2;
                                continue;
                            }
                            break;
                        }
                        InitialDeploymentTask.this.logger.debug("Saved mapping with label " + each.getId());
                        newDeployment.addMapping((Mapping)context.toPojo(each));
                    }
                    ConfigurationItemEntity updatedNewDeploymentEntity = context.toEntity(newDeployment);
                    updatedNewDeploymentEntity.setCreatingTaskId(InitialDeploymentTask.this.getId());
                    InitialDeploymentTask.this.repositoryService.update(updatedNewDeploymentEntity);
                }
                finally {
                    context.destroy();
                }
                return null;
            }
        });
    }

    @Override
    public boolean isDeploymentTask() {
        return true;
    }
}

