/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.api.internal.DescriptorHelper;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.ExportHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.dto.ArtifactAndData;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDtos;
import com.xebialabs.deployit.core.api.dto.FullTaskInfos;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.dto.RepositoryObjectIds;
import com.xebialabs.deployit.core.api.resteasy.Date;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CliObject(name="repository")
@ClassHelp(description="Gateway to doing CRUD operations on all types of CIs")
public class RepositoryClient
extends DocumentedObject {
    private final Proxies proxies;
    private final DescriptorHelper descriptors;
    private final String parseDateFormat = "MM/dd/yyyy";
    private final String resultDateFormat = "dd MMM yyyy HH:mm z";
    private static final Logger logger = LoggerFactory.getLogger(RepositoryClient.class);

    public RepositoryClient() {
        this.proxies = null;
        this.descriptors = null;
    }

    public RepositoryClient(Proxies proxies) {
        this.proxies = proxies;
        this.descriptors = DescriptorHelper.getInstance(proxies);
    }

    @MethodHelp(description="Create a new CI in the repository", parameters={@ParameterHelp(name="ci", description="The CI (ConfigurationItem) that should be created in the repository")})
    public RepositoryObject create(ConfigurationItemDto object) {
        Preconditions.checkArgument((object.getId() != null ? 1 : 0) != 0, (Object)"The repository object should have a set id.");
        Response response = this.proxies.getRepository().create(object.getId(), object);
        return this.checkForValidations(response);
    }

    @MethodHelp(description="Create a new artifact CI in the repository", parameters={@ParameterHelp(name="artifact", description="The Artifact that should be created in the repository")})
    public RepositoryObject create(ArtifactAndData artifact) {
        Preconditions.checkArgument((artifact.getArtifact().getId() != null ? 1 : 0) != 0, (Object)"The artifact should have a set id.");
        Response response = this.proxies.getRepository().create(artifact.getArtifact().getId(), artifact);
        return this.checkForValidations(response);
    }

    @MethodHelp(description="Create all new CIs in the repository, commonly used after a discovery", parameters={@ParameterHelp(name="cis", description="The CIs (ConfigurationItems) that should be created in the repository")})
    public ConfigurationItemDtos create(ConfigurationItemDtos repositoryObjects) {
        Response response = this.proxies.getRepository().createMultiple(repositoryObjects);
        return this.checkAllForValidations(response);
    }

    private ConfigurationItemDtos checkAllForValidations(Response response) {
        ResponseExtractor responseExtractor = new ResponseExtractor(response);
        ConfigurationItemDtos cis = (ConfigurationItemDtos)responseExtractor.getEntity();
        if (!responseExtractor.isValidResponse()) {
            for (ConfigurationItemDto repositoryObject : cis.getObjects()) {
                if (repositoryObject.getValidations().isEmpty()) continue;
                logger.error("Configuration item contained validation errors: {}", (Object)repositoryObject.getValidations());
            }
        }
        return cis;
    }

    @MethodHelp(description="Read a CI form the repository", parameters={@ParameterHelp(name="id", description="The id of the CI to read")})
    public RepositoryObject read(String id) {
        return (RepositoryObject)new ResponseExtractor(this.proxies.getRepository().read(id)).getEntity();
    }

    @MethodHelp(description="Update an existing CI in the repository", parameters={@ParameterHelp(name="ci", description="The updated CI (ConfigurationItem) that should be stored in the repository")})
    public RepositoryObject update(ConfigurationItemDto object) {
        Preconditions.checkArgument((object.getId() != null ? 1 : 0) != 0, (Object)"The repository object should have a set id.");
        Response response = this.proxies.getRepository().update(object.getId(), object);
        return this.checkForValidations(response);
    }

    @MethodHelp(description="Update an existing artifact in the repository", parameters={@ParameterHelp(name="artifact", description="The updated artifact CI that should be stored in the repository")})
    public RepositoryObject update(ArtifactAndData artifact) {
        Preconditions.checkArgument((artifact.getArtifact().getId() != null ? 1 : 0) != 0, (Object)"The repository object should have a set id.");
        Response response = this.proxies.getRepository().update(artifact.getArtifact().getId(), artifact);
        return this.checkForValidations(response);
    }

    @MethodHelp(description="Delete a CI with a specific id from the repository", parameters={@ParameterHelp(name="id", description="The id of the CI")})
    public void delete(String id) {
        new ResponseExtractor(this.proxies.getRepository().delete(id));
    }

    @MethodHelp(description="Search for CIs of a specific type in the repository", parameters={@ParameterHelp(name="ciType", description="")}, returns="The ids of the configuration items that fit the query.")
    public List<String> search(String ciType) {
        String type = null;
        if (ciType != null && (type = this.descriptors.getRegisteredType(ciType)) == null) {
            System.err.println("Configuration item type [" + type + "] not known.");
            return null;
        }
        RepositoryObjectIds ids = (RepositoryObjectIds)new ResponseExtractor(this.proxies.getQuery().list(type, Boolean.FALSE.booleanValue(), 0L, -1L, null, null, null)).getEntity();
        return ids.getRepositoryEntityIds();
    }

    @MethodHelp(description="Search for CIs of a specific type in the repository which are located under the specified parent node.", parameters={@ParameterHelp(name="ciType", description="The type of configuration item to look for (eg. udm.DeployedApplication)"), @ParameterHelp(name="parent", description="The id of the parent node to search under (eg. Environments/env1)")}, returns="The ids of the configuration items that fit the query.")
    public List<String> search(String ciType, String parent) {
        String type = this.descriptors.getRegisteredType(ciType);
        RepositoryObjectIds ids = (RepositoryObjectIds)new ResponseExtractor(this.proxies.getQuery().list(type, Boolean.FALSE.booleanValue(), 0L, -1L, null, parent, null)).getEntity();
        return ids.getRepositoryEntityIds();
    }

    public List<String> search(String ciType, Calendar c) {
        RepositoryObjectIds ids = (RepositoryObjectIds)new ResponseExtractor(this.proxies.getQuery().search(ciType, new Date(c))).getEntity();
        return ids.getRepositoryEntityIds();
    }

    @MethodHelp(description="Read multiple objects from the repostory in one go.", parameters={@ParameterHelp(name="ids", description="The ids of the objects to read")})
    public List<ConfigurationItemDto> read(String ... ids) {
        RepositoryObjectIds repositoryObjectIds = new RepositoryObjectIds();
        repositoryObjectIds.setRepositoryEntityIds(Arrays.asList(ids));
        ConfigurationItemDtos objs = (ConfigurationItemDtos)new ResponseExtractor(this.proxies.getQuery().readMultiple(repositoryObjectIds)).getEntity();
        return objs.getObjects();
    }

    @MethodHelp(description="Get all task information, including steps, from the repository's archive.", returns="This object contains all archived tasks with their enclosed steps")
    public FullTaskInfos getArchivedTasks() {
        return (FullTaskInfos)new ResponseExtractor(this.proxies.getTaskExport().getFullArchivedTasks()).getEntity();
    }

    @MethodHelp(description="Get all task information, including steps, from the repository's archive in the specified date range.", parameters={@ParameterHelp(name="beginDate", description="Begin date from which to return tasks in 'MM/dd/yyyy' format"), @ParameterHelp(name="endDate", description="End date from which to return tasks in 'MM/dd/yyyy' format")}, returns="This object contains all archived tasks with their enclosed steps")
    public FullTaskInfos getArchivedTasks(String beginDate, String endDate) {
        return (FullTaskInfos)new ResponseExtractor(this.proxies.getTaskExport().getFullArchivedTasksInDateRange(new Date(ExportHelp.parseDateFormat(beginDate, "MM/dd/yyyy", "dd MMM yyyy HH:mm z")), new Date(ExportHelp.parseDateFormat(endDate, "MM/dd/yyyy", "dd MMM yyyy HH:mm z")))).getEntity();
    }

    @MethodHelp(description="Export all task information, including steps, from the repository's archive to a local XML file", parameters={@ParameterHelp(name="filePath", description="Fully qualified pathname, including the file name, as to where to store the file to. Example: '/tmp/exportedTasks.xml'")})
    public void exportArchivedTasks(String filePath) throws IOException {
        this.getResourceToWrite(filePath, "/deployit/export/tasks");
    }

    @MethodHelp(description="Export all task information, including steps, from the repository's archive in the specified date range to a local XML file", parameters={@ParameterHelp(name="filePath", description="Fully qualified pathname, including the file name, as to where to store the file to. Example: '/tmp/exportedTasks.xml'"), @ParameterHelp(name="beginDate", description="Begin date from which to return tasks in 'MM/dd/yyyy' format"), @ParameterHelp(name="endDate", description="End date from which to return tasks in 'MM/dd/yyyy' format")})
    public void exportArchivedTasks(String filePath, String beginDate, String endDate) throws IOException {
        this.getResourceToWrite(filePath, String.format("/deployit/export/taskrange?begin=%s&end=%s", ExportHelp.encodeURIDateFormat(ExportHelp.parseDateFormat(beginDate, "MM/dd/yyyy", "dd MMM yyyy HH:mm z"), "UTF-8"), ExportHelp.encodeURIDateFormat(ExportHelp.parseDateFormat(endDate, "MM/dd/yyyy", "dd MMM yyyy HH:mm z"), "UTF-8")));
    }

    private RepositoryObject checkForValidations(Response response) {
        ResponseExtractor responseExtractor = new ResponseExtractor(response);
        RepositoryObject ci = (RepositoryObject)responseExtractor.getEntity();
        if (!responseExtractor.isValidResponse() && !ci.getValidations().isEmpty()) {
            logger.error("Configuration item contained validation errors: {}", (Object)ci.getValidations());
        }
        return ci;
    }

    private final void getResourceToWrite(String filePath, String resourcePath) throws IOException {
        if (ExportHelp.writeResourceToLocalFile(this.proxies.getAuthentication(), filePath, resourcePath) > 0L) {
            System.out.println(String.format("Written archived tasks to %s", filePath));
        } else {
            System.out.println("File was created but no bytes were written to the file.\n");
            System.out.println("Maybe the requested resource was not available or zero size!?");
        }
    }
}

