/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.scannit.reader;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceConfigurationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveEntrySupplier {
    private final URI uri;
    private static final Logger logger = LoggerFactory.getLogger(ArchiveEntrySupplier.class);

    public ArchiveEntrySupplier(URI uri) {
        this.uri = uri;
    }

    public void withArchiveEntries(Predicate<TFile> with) {
        TFile tFile = this.getTFile(this.uri);
        List<TFile> entries = this.list(tFile);
        for (TFile file : entries) {
            with.apply((Object)file);
        }
        this.closeTFile(tFile);
    }

    private List<TFile> list(TFile tFile) {
        ArrayList entries = Lists.newArrayList();
        if (tFile.isArchive()) {
            this.gatherEntries(tFile, entries, true);
        } else {
            this.gatherEntries(tFile, entries, false);
        }
        return entries;
    }

    protected void closeTFile(TFile tFile) {
        try {
            if (tFile.isArchive()) {
                TFile.umount((TFile)tFile);
            }
        }
        catch (FsSyncException e) {
            logger.error("Could not umount {}, continuing", (Object)tFile);
            logger.debug("Exception was: ", (Throwable)e);
        }
    }

    private TFile getTFile(URI uri) {
        if (uri.getPath() != null) {
            return new TFile(uri.getPath());
        }
        return new TFile(uri);
    }

    private void gatherEntries(TFile tFile, List<TFile> files, boolean scanInArchives) {
        try {
            boolean hasFiles;
            boolean isArchive = tFile.isArchive();
            boolean isNormalDir = !isArchive && tFile.isDirectory();
            boolean bl = hasFiles = (isArchive || isNormalDir) && tFile.listFiles() != null;
            if (isNormalDir && hasFiles || isArchive && scanInArchives && hasFiles) {
                logger.trace("Listing directory/archive of file: {}", (Object)tFile);
                for (TFile file : tFile.listFiles()) {
                    this.gatherEntries(file, files, false);
                }
            } else if (tFile.isFile() || tFile.isEntry()) {
                logger.trace("Found file/entry {}", (Object)tFile);
                files.add(tFile);
            }
        }
        catch (RuntimeException re) {
            logger.error("Error scanning {}, continuing...", (Object)tFile);
            logger.debug("Exception was: ", (Throwable)re);
        }
        catch (ServiceConfigurationError re) {
            logger.error("Error scanning {}, continuing...", (Object)tFile);
            logger.debug("Error was: ", (Throwable)re);
        }
    }
}

