/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMethod;

public class HttpHeaderOverrideServletRequest
extends HttpServletRequestWrapper {
    private static final String DEFAULT_ACCEPT_HEADER = "Accept";
    public static final String DEFAULT_QUERY_PARAM = "acceptHeader";
    private final String headerOverrideQueryParam;
    private transient String method;
    private static Logger logger = LoggerFactory.getLogger(HttpHeaderOverrideServletRequest.class);

    public HttpHeaderOverrideServletRequest(HttpServletRequest request, String queryParam) {
        super(request);
        this.headerOverrideQueryParam = queryParam;
    }

    public Enumeration<String> getHeaders(String name) {
        if (this.shouldOverrideAcceptHeader(name).booleanValue()) {
            String acceptHeaderValue = "text/csv";
            return Collections.enumeration(Lists.newArrayList((Object[])new String[]{acceptHeaderValue}));
        }
        return super.getHeaders(name);
    }

    private Boolean shouldOverrideAcceptHeader(String name) {
        if (name.equalsIgnoreCase(DEFAULT_ACCEPT_HEADER)) {
            ArrayList requestParameterNames = Collections.list(super.getParameterNames());
            return requestParameterNames.contains(this.headerOverrideQueryParam);
        }
        return false;
    }

    public String getMethod() {
        if (this.method == null) {
            this.method = this.resolveMethod();
        }
        return this.method;
    }

    protected String resolveMethod() {
        String method;
        ArrayList requestParameterNames = Collections.list(super.getParameterNames());
        if (requestParameterNames.contains(this.headerOverrideQueryParam)) {
            method = RequestMethod.GET.toString();
            logger.debug("Overriding " + super.getMethod() + " request to be a " + method + " request because a " + this.headerOverrideQueryParam + " queryParameter was present");
        } else {
            method = super.getMethod();
            logger.debug("Not overriding a " + method + " request");
        }
        return method;
    }
}

