/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;

public class ConnectionOptions {
    public static final String OPERATING_SYSTEM = "os";
    public static final String TEMPORARY_DIRECTORY_PATH = "tmp";
    public static final String TEMPORARY_DIRECTORY_DELETE_ON_DISCONNECT = "tmpDeleteOnDisconnect";
    public static final boolean DEFAULT_TEMPORARY_DIRECTORY_DELETE_ON_DISCONNECT = true;
    public static final String TEMPORARY_FILE_CREATION_RETRIES = "tmpFileCreationRetries";
    public static final int DEFAULT_TEMPORARY_FILE_CREATION_RETRIES = 100;
    public static final String CONNECTION_TIMEOUT_MILLIS = "connectionTimeoutMillis";
    public static final int DEFAULT_CONNECTION_TIMEOUT_MILLIS = 120000;
    public static final String ADDRESS = "address";
    public static final String PORT = "port";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    private final Map<String, Object> options;

    public ConnectionOptions() {
        this.options = Maps.newHashMap();
    }

    public ConnectionOptions(ConnectionOptions options) {
        this.options = Maps.newHashMap(options.options);
    }

    public void set(String key, Object value) {
        this.options.put(key, value);
    }

    public <T> T get(String key) throws IllegalArgumentException {
        Object value = this.options.get(key);
        if (value == null) {
            throw new IllegalArgumentException("No value specified for required connection option " + key);
        }
        return (T)value;
    }

    public <T> T getOptional(String key) {
        return (T)this.options.get(key);
    }

    public <T> T get(String key, T defaultValue) {
        if (this.options.containsKey(key)) {
            return (T)this.options.get(key);
        }
        return defaultValue;
    }

    public Set<String> keys() {
        return this.options.keySet();
    }
}

