/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.winrm;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.cifs.CifsConnection;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import com.xebialabs.overthere.cifs.winrm.HttpConnector;
import com.xebialabs.overthere.cifs.winrm.TokenGenerator;
import com.xebialabs.overthere.cifs.winrm.WinRmClient;
import com.xebialabs.overthere.cifs.winrm.connector.JdkHttpConnector;
import com.xebialabs.overthere.cifs.winrm.connector.LaxJdkHttpConnector;
import com.xebialabs.overthere.cifs.winrm.exception.WinRMRuntimeIOException;
import com.xebialabs.overthere.cifs.winrm.tokengenerator.BasicTokenGenerator;
import java.net.MalformedURLException;
import java.net.URL;

public class CifsWinRmConnection
extends CifsConnection {
    private final WinRmClient winRmClient;

    public CifsWinRmConnection(String type, ConnectionOptions options) {
        super(type, options, false);
        Preconditions.checkArgument((this.os == OperatingSystemFamily.WINDOWS ? 1 : 0) != 0, (String)"Cannot start a cifs:%s connection to a non-Windows operating system", (Object[])new Object[]{this.cifsConnectionType.toString().toLowerCase()});
        TokenGenerator tokenGenerator = this.getTokenGenerator(options);
        URL targetURL = this.getTargetURL(options);
        HttpConnector httpConnector = CifsWinRmConnection.newHttpConnector(this.cifsConnectionType, targetURL, tokenGenerator);
        this.winRmClient = new WinRmClient(httpConnector, targetURL);
        this.winRmClient.setTimeout(options.get("winrmTimeout", "PT60.000S"));
        this.winRmClient.setEnvelopSize(options.get("winrmEnvelopSize", 153600));
        this.winRmClient.setLocale(options.get("winrmLocale", "en-US"));
    }

    private TokenGenerator getTokenGenerator(ConnectionOptions options) {
        String username = (String)options.get("username");
        String password = (String)options.get("password");
        return new BasicTokenGenerator(username, password);
    }

    private URL getTargetURL(ConnectionOptions options) {
        String scheme = this.cifsConnectionType == CifsConnectionType.WINRM_HTTP ? "http" : "https";
        String context = options.get("winrmContext", "/wsman");
        try {
            return new URL(scheme, this.address, this.port, context);
        }
        catch (MalformedURLException e) {
            throw new WinRMRuntimeIOException("Cannot build a new URL for " + this, e);
        }
    }

    public static HttpConnector newHttpConnector(CifsConnectionType ccType, URL targetURL, TokenGenerator tokenGenerator) {
        switch (ccType) {
            case WINRM_HTTP: {
                return new JdkHttpConnector(targetURL, tokenGenerator);
            }
            case WINRM_HTTPS: {
                return new LaxJdkHttpConnector(targetURL, tokenGenerator);
            }
        }
        throw new IllegalArgumentException("Invalid CIFS connection type " + (Object)((Object)ccType));
    }

    @Override
    public int execute(OverthereProcessOutputHandler handler, CmdLine commandLine) {
        String cmd = commandLine.toCommandLine(this.getHostOperatingSystem(), false);
        if (this.workingDirectory != null) {
            cmd = "CD " + this.workingDirectory.getPath() + " & " + cmd;
        }
        this.winRmClient.runCmd(cmd, handler);
        return this.winRmClient.getExitCode();
    }
}

