/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.winrm.connector;

import com.google.common.io.Closeables;
import com.xebialabs.overthere.cifs.winrm.HttpConnector;
import com.xebialabs.overthere.cifs.winrm.SoapAction;
import com.xebialabs.overthere.cifs.winrm.TokenGenerator;
import com.xebialabs.overthere.cifs.winrm.exception.BlankValueRuntimeException;
import com.xebialabs.overthere.cifs.winrm.exception.InvalidFilePathRuntimeException;
import com.xebialabs.overthere.cifs.winrm.exception.WinRMRuntimeIOException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkHttpConnector
implements HttpConnector {
    private final URL targetURL;
    private final TokenGenerator tokenGenerator;
    private static Logger logger = LoggerFactory.getLogger(JdkHttpConnector.class);

    public JdkHttpConnector(URL targetURL, TokenGenerator tokenGenerator) {
        this.targetURL = targetURL;
        this.tokenGenerator = tokenGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document sendMessage(Document requestDocument, SoapAction soapAction) {
        try {
            URLConnection urlConnection = this.targetURL.openConnection();
            HttpURLConnection con = (HttpURLConnection)urlConnection;
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/soap+xml; charset=UTF-8");
            String authToken = this.tokenGenerator.generateToken();
            if (authToken != null) {
                con.addRequestProperty("Authorization", authToken);
            }
            if (soapAction != null) {
                con.setRequestProperty("SOAPAction", soapAction.getValue());
            }
            String requestDocAsString = this.toString(requestDocument);
            logger.trace("Sending request to {}", (Object)this.targetURL);
            logger.trace("Request body: {}", (Object)this.targetURL, (Object)requestDocAsString);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(con.getOutputStream()));
            try {
                bw.write(requestDocAsString, 0, requestDocAsString.length());
            }
            finally {
                Closeables.closeQuietly((Closeable)bw);
            }
            InputStream is = null;
            if (con.getResponseCode() >= 400) {
                is = con.getErrorStream();
            }
            if (is == null) {
                is = con.getInputStream();
            }
            StringWriter writer = new StringWriter();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            try {
                int n;
                char[] buffer = new char[1024];
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                Closeables.closeQuietly((Closeable)reader);
                Closeables.closeQuietly((Closeable)is);
            }
            if (logger.isDebugEnabled()) {
                for (int i = 0; i < con.getHeaderFields().size(); ++i) {
                    logger.trace("Header {}: {}", (Object)con.getHeaderFieldKey(i), (Object)con.getHeaderField(i));
                }
            }
            String text = ((Object)writer).toString();
            logger.trace("Response body: {}", (Object)text);
            return DocumentHelper.parseText((String)text);
        }
        catch (BlankValueRuntimeException bvrte) {
            throw bvrte;
        }
        catch (InvalidFilePathRuntimeException ifprte) {
            throw ifprte;
        }
        catch (Exception e) {
            throw new WinRMRuntimeIOException("Send message on " + this.targetURL + " error ", requestDocument, null, e);
        }
    }

    private String toString(Document doc) {
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, OutputFormat.createPrettyPrint());
        try {
            xmlWriter.write(doc);
            xmlWriter.close();
        }
        catch (IOException e) {
            throw new WinRMRuntimeIOException("Cannnot convert XML to String ", e);
        }
        return stringWriter.toString();
    }
}

