/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.ssh.SshScpConnection;
import com.xebialabs.overthere.ssh.SshScpFile;
import com.xebialabs.overthere.ssh.SshSudoConnection;
import com.xebialabs.overthere.ssh.SshSudoOutputStream;
import com.xebialabs.overthere.util.CapturingOverthereProcessOutputHandler;
import com.xebialabs.overthere.util.LoggingOverthereProcessOutputHandler;
import com.xebialabs.overthere.util.MultipleOverthereProcessOutputHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSudoFile
extends SshScpFile {
    private boolean isTempFile;
    private Logger logger = LoggerFactory.getLogger(SshSudoFile.class);

    public SshSudoFile(SshSudoConnection connection, String remotePath, boolean isTempFile) {
        super(connection, remotePath);
        this.isTempFile = isTempFile;
    }

    @Override
    protected int executeCommand(OverthereProcessOutputHandler handler, CmdLine commandLine) {
        if (this.isTempFile) {
            return ((SshSudoConnection)this.connection).noSudoExecute(handler, commandLine);
        }
        return super.executeCommand(handler, commandLine);
    }

    @Override
    public OverthereFile getFile(String name) {
        SshSudoFile f = (SshSudoFile)super.getFile(name);
        f.isTempFile = this.isTempFile;
        return f;
    }

    @Override
    public OverthereFile getParentFile() {
        SshSudoFile f = (SshSudoFile)super.getParentFile();
        f.isTempFile = this.isTempFile;
        return f;
    }

    @Override
    public InputStream getInputStream() throws RuntimeIOException {
        if (this.isTempFile) {
            return super.getInputStream();
        }
        OverthereFile tempFile = ((SshScpConnection)this.connection).getTempFile(this.getName());
        this.copyToTempFile(tempFile);
        return tempFile.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws RuntimeIOException {
        if (this.isTempFile) {
            return super.getOutputStream();
        }
        this.logger.debug("Opening ssh:sudo: output stream to write to file {}", (Object)this);
        return new SshSudoOutputStream(this, ((SshScpConnection)this.connection).getTempFile(this.getName()));
    }

    @Override
    public void mkdir() throws RuntimeIOException {
        if (this.isTempFile) {
            this.logger.debug("Creating world-writable directory, with sticky bit (mode 01777)");
            this.mkdir("-m", "1777");
        } else {
            super.mkdir();
        }
    }

    @Override
    public void mkdirs() throws RuntimeIOException {
        if (this.isTempFile) {
            this.logger.debug("Creating world-writable directories, with sticky bit (mode 01777)");
            this.mkdir("-p", "-m", "1777");
        } else {
            super.mkdirs();
        }
    }

    @Override
    protected void copyFrom(OverthereFile source) {
        if (this.isTempFile) {
            super.copyFrom(source);
            this.overrideUmask(this);
        } else {
            this.logger.debug("Copying file or directory {} to {}", (Object)source, (Object)this);
            OverthereFile tempFile = ((SshScpConnection)this.getConnection()).getTempFile(this.getName());
            try {
                ((SshScpConnection)this.connection).getSshClient().newSCPFileTransfer().newSCPUploadClient().copy((LocalSourceFile)new SshScpFile.OverthereFileLocalSourceFile(source), tempFile.getPath());
            }
            catch (IOException e) {
                throw new RuntimeIOException("Cannot copy " + source + " to " + this, e);
            }
            this.overrideUmask(tempFile);
            this.copyfromTempFile(tempFile);
        }
    }

    private void overrideUmask(OverthereFile remoteFile) {
        if (((SshSudoConnection)this.connection).sudoOverrideUmask) {
            this.logger.debug("Overriding umask by recursively setting permissions on files and/or directories copied with scp to be readable and executable (if needed) by group and other");
            CapturingOverthereProcessOutputHandler capturedOutput = CapturingOverthereProcessOutputHandler.capturingHandler();
            int errno = ((SshSudoConnection)this.connection).noSudoExecute(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturedOutput), CmdLine.build("chmod", "-R", "go+rX", remoteFile.getPath()));
            if (errno != 0) {
                throw new RuntimeIOException("Cannot set permissions on file " + this + " to go+rX: " + capturedOutput.getError() + " (errno=" + errno + ")");
            }
        }
    }

    void copyToTempFile(OverthereFile tempFile) {
        this.logger.debug("Copying actual file {} to temporary file {} before download", (Object)this, (Object)tempFile);
        CapturingOverthereProcessOutputHandler cpCapturedOutput = CapturingOverthereProcessOutputHandler.capturingHandler();
        int cpResult = ((SshScpConnection)this.getConnection()).execute(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), cpCapturedOutput), CmdLine.build("cp", "-pr", this.getPath(), tempFile.getPath()));
        if (cpResult != 0) {
            String errorMessage = cpCapturedOutput.getAll();
            throw new RuntimeIOException("Cannot copy actual file " + this + " to temporary file " + tempFile + " before download: " + errorMessage);
        }
        CapturingOverthereProcessOutputHandler chmodCapturedOutput = CapturingOverthereProcessOutputHandler.capturingHandler();
        int chmodResult = ((SshScpConnection)this.getConnection()).execute(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), chmodCapturedOutput), CmdLine.build("chmod", "-R", "go+rX", tempFile.getPath()));
        if (chmodResult != 0) {
            String errorMessage = chmodCapturedOutput.getAll();
            throw new RuntimeIOException("Cannot grant group and other read and execute permissions (chmod -R go+rX) to file " + tempFile + " before download: " + errorMessage);
        }
    }

    void copyfromTempFile(OverthereFile tempFile) {
        this.logger.debug("Copying temporary file {} to actual file {} after upload", (Object)tempFile, (Object)this);
        CapturingOverthereProcessOutputHandler cpCapturedOutput = CapturingOverthereProcessOutputHandler.capturingHandler();
        CmdLine cmdLine = CmdLine.build("cp", "-pr");
        String sourcePath = tempFile.getPath();
        if (this.exists() && tempFile.isDirectory()) {
            sourcePath = sourcePath + "/*";
        }
        cmdLine.addRaw(sourcePath);
        cmdLine.addArgument(this.getPath());
        int cpResult = ((SshScpConnection)this.getConnection()).execute(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), cpCapturedOutput), cmdLine);
        if (cpResult != 0) {
            String errorMessage = cpCapturedOutput.getAll();
            throw new RuntimeIOException("Cannot copy temporary file " + tempFile + " to actual file " + this + " after upload: " + errorMessage);
        }
    }
}

