/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.dto.ArtifactDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDtos;
import com.xebialabs.deployit.core.api.dto.Message;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.util.PasswordObfuscator;
import com.xebialabs.overthere.OverthereFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationItemDtoWriter {
    public ConfigurationItemDtos write(Collection<ConfigurationItem> cis) {
        ConfigurationItemDtos dtos = new ConfigurationItemDtos();
        for (ConfigurationItem ci : cis) {
            dtos.add(this.write(ci));
        }
        return dtos;
    }

    public ConfigurationItemDto write(ConfigurationItem ci) {
        ArtifactDto dto;
        if (ci instanceof Artifact) {
            dto = new ArtifactDto(ci.getType().toString());
            dto.setId(ci.getId());
            OverthereFile file = ((Artifact)ci).getFile();
            if (file != null) {
                dto.setFilename(file.getName());
            }
        } else {
            dto = new ConfigurationItemDto(ci.getId(), ci.getType().toString());
        }
        this.copyValues(ci, (ConfigurationItemDto)dto);
        return dto;
    }

    private void copyValues(ConfigurationItem ci, ConfigurationItemDto dto) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)ci.getType());
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            Object value = pd.get(ci);
            if (value == null) continue;
            switch (pd.getKind()) {
                case STRING: {
                    if (pd.isPassword()) {
                        value = PasswordObfuscator.ensureEncrypted((String)((String)value));
                    }
                }
                case BOOLEAN: 
                case INTEGER: 
                case ENUM: {
                    dto.setProperty(pd.getName(), (Object)value.toString());
                    break;
                }
                case SET_OF_STRING: {
                    dto.setProperty(pd.getName(), (Object)Sets.newHashSet((Iterable)((Collection)value)));
                    break;
                }
                case SET_OF_CI: {
                    dto.setProperty(pd.getName(), this.handleSetOfCi((Collection)value));
                    break;
                }
                case CI: {
                    dto.setProperty(pd.getName(), (Object)((ConfigurationItem)value).getId());
                    break;
                }
                case MAP_STRING_STRING: {
                    dto.setProperty(pd.getName(), (Object)Maps.newHashMap((Map)((Map)value)));
                }
            }
        }
    }

    private Set<String> handleSetOfCi(Collection<ConfigurationItem> value) {
        return Sets.newHashSet((Iterable)Collections2.transform(value, (Function)new Function<ConfigurationItem, String>(){

            public String apply(ConfigurationItem input) {
                return input.getId();
            }
        }));
    }

    public ConfigurationItemDto write(ConfigurationItem ci, List<ValidationMessage> messages) {
        ConfigurationItemDto dto = this.write(ci);
        for (ValidationMessage vm : messages) {
            dto.addValidation(new Message(vm.getPropertyName(), vm.getMessage()));
        }
        return dto;
    }

    public List<ConfigurationItemDto> write(ListMultimap<Boolean, ConfigurationItem> deployeds) {
        Checks.checkNotNull(deployeds, (String)"deployeds");
        ArrayList cis = Lists.newArrayList();
        for (ConfigurationItem validDeployedEntity : deployeds.get((Object)true)) {
            ConfigurationItemDto validDeployed = this.write(validDeployedEntity);
            cis.add(validDeployed);
        }
        for (ConfigurationItem invalidDeployedEntity : deployeds.get((Object)false)) {
            ConfigurationItemDto invalidDeployed = this.write(invalidDeployedEntity);
            ArrayList<Message> validations = new ArrayList<Message>();
            validations.add(new Message("source", "The deployable for this deployed is missing from the package."));
            invalidDeployed.setValidations(validations);
            cis.add(invalidDeployed);
        }
        return cis;
    }
}

