/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.ServerProxy;
import com.xebialabs.deployit.core.api.dto.ServerInfo;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.event.Event;
import com.xebialabs.deployit.event.EventBus;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.service.gc.GarbageCollectionService;
import java.io.IOException;
import java.util.Properties;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;

@Controller
public class ServerResource
implements ServerProxy {
    @Autowired
    private GarbageCollectionService garbageCollectionService;

    public Response shutdown() {
        EventBus.publish((Event)new ShutdownEvent());
        return ResponseFactory.noContent().build();
    }

    public Response getInfo() {
        ClassPathResource resource = new ClassPathResource("com/xebialabs/deployit/release.properties");
        Properties release = new Properties();
        try {
            release.load(resource.getInputStream());
            ServerInfo si = new ServerInfo();
            si.setVersion(release.getProperty("version"));
            return ResponseFactory.ok((Object)si).build();
        }
        catch (IOException e) {
            throw new DeployitException((Throwable)e);
        }
    }

    public Response gc() {
        this.garbageCollectionService.runGarbageCollector();
        return ResponseFactory.noContent().build();
    }
}

