/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class DeploymentsKeyIndicator {
    private TaskArchive taskArchive;

    public DeploymentsKeyIndicator(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public Report report(Date startDate, Date endDate) {
        final ConcurrentMap tasksMap = new MapMaker().makeComputingMap((Function)new Function<String, TaskStateData>(){

            public TaskStateData apply(String input) {
                return new TaskStateData();
            }
        });
        ArchivedTaskSearchParameters searchTasks = new ArchivedTaskSearchParameters().createdBetween(startDate.getCalendar(), endDate.getCalendar());
        this.taskArchive.searchTasksWithoutLoadingSteps(searchTasks, new JcrTaskArchive.TaskCallback(){

            public void doWithTask(DeploymentTaskInfo task) {
                DeploymentsKeyIndicator.this.fillMapWithTask(tasksMap, task);
            }
        });
        return this.generateReportDataFromTaskMap(tasksMap);
    }

    private Report generateReportDataFromTaskMap(Map<String, TaskStateData> tasksMap) {
        Report report = new Report();
        for (Map.Entry<String, TaskStateData> entry : tasksMap.entrySet()) {
            Report.ReportLine reportLine = report.addLine();
            reportLine.addValue("application", (Object)entry.getKey().substring(0, entry.getKey().indexOf("~")));
            reportLine.addValue("environment", (Object)entry.getKey().substring(entry.getKey().indexOf("~") + 1, entry.getKey().length()));
            reportLine.addValue("noOfSuccessfulDeployments", (Object)entry.getValue().getNoOfSuccessfulDeployments().toString());
            reportLine.addValue("noOfFailedDeployments", (Object)entry.getValue().getNoOfFailedDeployments().toString());
            reportLine.addValue("noOfAbortedDeployments", (Object)entry.getValue().getNoOfAbortedDeployments().toString());
            String averageDeploymentTime = "00:00:00";
            if (entry.getValue().getTotalSuccessfulTasks() > 0) {
                averageDeploymentTime = ReportUtils.formatToHoursMinsSecs(entry.getValue().getAverageDeploymentTime() / (long)entry.getValue().getTotalSuccessfulTasks());
            }
            reportLine.addValue("averageDuration", (Object)averageDeploymentTime);
        }
        return report;
    }

    private void fillMapWithTask(Map<String, TaskStateData> tasksMap, DeploymentTaskInfo task) {
        String entityId = task.getApplicationName() + "~" + task.getEnvironment();
        TaskStateData taskStateData = tasksMap.get(entityId);
        taskStateData.addTaskAndDuration(task);
    }
}

