/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Widget;
import com.xebialabs.deployit.task.TaskArchive;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

abstract class DashboardWidgetBase
implements Widget {
    protected TaskArchive taskArchive;
    final SimpleDateFormat monthFormat = new SimpleDateFormat("MMM", Locale.ENGLISH);

    DashboardWidgetBase() {
    }

    protected final double getPercentage(double numOfTasksInAState, double totalTasks) {
        Preconditions.checkArgument((numOfTasksInAState <= totalTasks ? 1 : 0) != 0, (Object)("Number of deplyments in a state passed to the percentage function cannot be greater than total number of deployments! numOfDeployment :" + numOfTasksInAState + "totalDeployment:" + totalTasks));
        return totalTasks == 0.0 ? 0.0 : numOfTasksInAState / totalTasks * 100.0;
    }

    final String formatToMinsAndSecs(long millis) {
        long secs = TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis));
        String seconds = String.valueOf(secs);
        if (secs < 10L) {
            seconds = "0" + seconds;
        }
        return String.format("%d:%s", TimeUnit.MILLISECONDS.toMinutes(millis), seconds);
    }

    protected final String formatToMins(long millis) {
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis);
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(minutes);
        if (seconds >= 30L) {
            ++minutes;
        }
        return String.format("%d", minutes);
    }

    protected <T> Map<String, T> initializeMap(Date begin, Date end, Function<String, T> f) {
        LinkedHashMap groupedTasks = Maps.newLinkedHashMap();
        Calendar month = (Calendar)begin.getCalendar().clone();
        month.set(5, 1);
        Calendar endMonth = (Calendar)end.getCalendar().clone();
        endMonth.set(5, 1);
        while (month.compareTo(endMonth) <= 0) {
            String mnth = this.monthFormat.format(month.getTime());
            groupedTasks.put(mnth, f.apply((Object)mnth));
            month.add(2, 1);
        }
        return groupedTasks;
    }
}

