/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.jcr.grouping.Count;
import com.xebialabs.deployit.jcr.grouping.Function;
import com.xebialabs.deployit.jcr.grouping.GroupBy;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class Top5DeploymentsByState
extends DashboardWidgetBase {
    static final String FAILURE_COUNT = "failureCount";
    static final String STATE = "state";
    static final String COUNT = "count";
    static final String APPLICATION_NAME = "applicationName";

    abstract boolean accept(Map<String, Object> var1);

    @Override
    public Report getReport(Date begin, Date end) {
        ArchivedTaskSearchParameters sp = new ArchivedTaskSearchParameters();
        sp.createdBetween(begin.getCalendar(), end.getCalendar());
        Collection searchResult = this.taskArchive.searchTasksWithoutLoadingSteps(sp, new GroupBy((Collection)Lists.newArrayList((Object[])new String[]{APPLICATION_NAME, STATE, FAILURE_COUNT}), new Function[]{new Count(COUNT)}));
        return this.getTop5(searchResult);
    }

    private Report getTop5(Collection<Map<String, Object>> searchResult) {
        Map<String, Integer> totalsMap = this.calculateTotalsPerApplication(searchResult);
        List<Map<String, Object>> list = this.filterByState(searchResult);
        Collections.sort(list, new Top5Comparator(totalsMap));
        DecimalFormat df = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        Report report = new Report();
        for (Map<String, Object> line : list.subList(0, Math.min(list.size(), 5))) {
            Report.ReportLine reportLine = report.addLine();
            reportLine.addValue(APPLICATION_NAME, (Object)((String)line.get(APPLICATION_NAME)));
            reportLine.addValue("numOfDeployments", (Object)((Integer)line.get(COUNT)).toString());
            reportLine.addValue("percentage", (Object)df.format(this.getPercentage(((Integer)line.get(COUNT)).intValue(), totalsMap.get((String)line.get(APPLICATION_NAME)).intValue())));
        }
        return report;
    }

    private Map<String, Integer> calculateTotalsPerApplication(Collection<Map<String, Object>> resultList) {
        HashMap totals = Maps.newHashMap();
        for (Map<String, Object> line : resultList) {
            Integer total = (Integer)totals.get((String)line.get(APPLICATION_NAME));
            total = total == null ? (Integer)line.get(COUNT) : Integer.valueOf(total + (Integer)line.get(COUNT));
            totals.put((String)line.get(APPLICATION_NAME), total);
        }
        return totals;
    }

    private List<Map<String, Object>> filterByState(Collection<Map<String, Object>> searchResult) {
        ArrayList list = Lists.newArrayList();
        for (Map<String, Object> line : searchResult) {
            if (!this.accept(line)) continue;
            list.add(line);
        }
        return list;
    }

    private static final class Top5Comparator
    implements Comparator<Map<String, Object>> {
        private final Map<String, Integer> totalsMap;

        private Top5Comparator(Map<String, Integer> totalsMap) {
            this.totalsMap = totalsMap;
        }

        @Override
        public int compare(Map<String, Object> o1, Map<String, Object> o2) {
            int comparisonResult = ((Integer)o1.get(Top5DeploymentsByState.COUNT)).compareTo((Integer)o2.get(Top5DeploymentsByState.COUNT));
            if (comparisonResult == 0) {
                Integer total1 = this.totalsMap.get((String)o1.get(Top5DeploymentsByState.APPLICATION_NAME));
                Integer total2 = this.totalsMap.get((String)o2.get(Top5DeploymentsByState.APPLICATION_NAME));
                comparisonResult = -total1.compareTo(total2);
            }
            return -comparisonResult;
        }
    }
}

