/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.plugin.Imploder;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.util.PasswordObfuscator;
import com.xebialabs.overthere.OverthereFile;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.value.ReferenceValue;

class NodeWriter {
    private final Session session;
    private final ConfigurationItem item;
    private final Node node;
    private boolean basicsWritten = false;

    NodeWriter(Session session, ConfigurationItem item, Node node) {
        this.session = session;
        this.item = item;
        this.node = node;
    }

    void writeBasics() throws RepositoryException {
        this.copyConfigurationItemTypeName();
        this.basicsWritten = true;
    }

    void write() throws RepositoryException {
        if (!this.basicsWritten) {
            this.writeBasics();
        }
        this.copyData();
        this.copyValuesIntoNode();
        this.copyMetadata();
    }

    private void copyConfigurationItemTypeName() throws RepositoryException {
        this.node.setProperty("$configuration.item.type", this.item.getType().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyData() throws RepositoryException {
        OverthereFile file;
        if (this.item instanceof SourceArtifact && (file = ((Artifact)this.item).getFile()) != null) {
            InputStream dataInput;
            this.node.setProperty("$filename", file.getName());
            if (this.item instanceof FolderArtifact && file.isDirectory()) {
                try {
                    byte[] implode = Imploder.implode(file);
                    dataInput = new ByteArrayInputStream(implode);
                }
                catch (IOException e) {
                    throw new RuntimeIOException("Could not zip up the data in file " + file);
                }
            } else {
                dataInput = file.getInputStream();
            }
            try {
                Binary binary = this.session.getValueFactory().createBinary(dataInput);
                this.node.setProperty("$data", binary);
            }
            finally {
                Closeables.closeQuietly((Closeable)dataInput);
            }
        }
    }

    private void copyValuesIntoNode() throws RepositoryException {
        Descriptor ciDescriptor = DescriptorRegistry.getDescriptor((Type)this.item.getType());
        Collection propertyDescriptors = Collections2.filter((Collection)ciDescriptor.getPropertyDescriptors(), (Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return !input.isTransient();
            }
        });
        block7: for (PropertyDescriptor pd : propertyDescriptors) {
            if (pd.get(this.item) == null) {
                this.removePropertyFromNode(pd);
                continue;
            }
            switch (pd.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    this.copyPrimitivePropertyIntoNode(pd);
                    continue block7;
                }
                case SET_OF_STRING: {
                    this.copySetOfStringsPropertyIntoNode(pd);
                    continue block7;
                }
                case CI: {
                    this.copyConfigurationItemPropertyIntoNode(pd);
                    continue block7;
                }
                case SET_OF_CI: {
                    this.copySetOfConfigurationItemsPropertyIntoNode(pd);
                    continue block7;
                }
                case MAP_STRING_STRING: {
                    this.copyMapPropertyIntoNode(pd);
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Cannot convert property " + pd.getName() + " because it is of unsupported kind " + pd.getKind());
        }
    }

    private void copyMapPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        Map value = (Map)pd.get(this.item);
        ArrayList valueList = Lists.newArrayList();
        for (String s : value.keySet()) {
            Value v = this.session.getValueFactory().createValue(s + "=" + (String)value.get(s));
            valueList.add(v);
        }
        Value[] jcrValues = valueList.toArray(new Value[valueList.size()]);
        this.node.setProperty(pd.getName(), jcrValues);
    }

    private void copyMetadata() throws RepositoryException {
        this.node.setProperty("$id", this.item.getId());
        this.node.setProperty("$lastModified", Calendar.getInstance());
    }

    private void removePropertyFromNode(PropertyDescriptor pd) throws RepositoryException {
        try {
            this.node.getProperty(pd.getName()).remove();
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    private void copyPrimitivePropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        String valueAsString = pd.get(this.item).toString();
        if (pd.getKind() == PropertyKind.STRING && pd.isPassword()) {
            valueAsString = PasswordObfuscator.ensureEncrypted(valueAsString);
        }
        this.node.setProperty(pd.getName(), valueAsString);
    }

    private void copySetOfStringsPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        ValueFactory valueFactory = this.session.getValueFactory();
        Collection<?> valueAsCollection = this.convertObjectValueToCollection(pd, pd.get(this.item));
        ArrayList jcrValueList = Lists.newArrayList();
        for (Object each : valueAsCollection) {
            if (!(each instanceof String)) {
                throw new IllegalArgumentException("Element in property " + pd.getName() + " of repository entity " + this.item.getId() + " is not a String: " + each);
            }
            String stringValue = (String)each;
            jcrValueList.add(valueFactory.createValue(stringValue));
        }
        Value[] jcrValues = jcrValueList.toArray(new Value[jcrValueList.size()]);
        this.node.setProperty(pd.getName(), jcrValues);
    }

    private void copyConfigurationItemPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        if (pd.isAsContainment()) {
            return;
        }
        String referencedCiId = ((ConfigurationItem)pd.get(this.item)).getId();
        Node referencedCi = this.session.getNode(JcrPathHelper.getAbsolutePathFromId(referencedCiId));
        this.node.setProperty(pd.getName(), referencedCi);
    }

    private void copySetOfConfigurationItemsPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        if (pd.isAsContainment()) {
            return;
        }
        Collection<?> valueAsCollection = this.convertObjectValueToCollection(pd, pd.get(this.item));
        ArrayList jcrReferenceList = Lists.newArrayList();
        for (Object each : valueAsCollection) {
            if (!(each instanceof ConfigurationItem)) {
                throw new IllegalArgumentException("Element in property " + pd.getName() + " of repository entity " + this.item.getId() + " is not a ConfigurationItem: " + each);
            }
            String referencedCiId = ((ConfigurationItem)each).getId();
            Node referencedCi = this.session.getNode(JcrPathHelper.getAbsolutePathFromId(referencedCiId));
            jcrReferenceList.add(new ReferenceValue(referencedCi));
        }
        Value[] jcrReferenceValues = jcrReferenceList.toArray(new Value[jcrReferenceList.size()]);
        this.node.setProperty(pd.getName(), jcrReferenceValues);
    }

    private Collection<?> convertObjectValueToCollection(PropertyDescriptor pd, Object value) {
        if (!(value instanceof Collection)) {
            throw new IllegalArgumentException("Property " + pd.getName() + " of repository entity " + this.item.getId() + " is not a Collection: " + value);
        }
        return (Collection)value;
    }
}

