/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.SearchParameters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchQueryBuilder {
    public static final String CI_SELECTOR_NAME = "ci";
    private static final String EQUALITY_OPERATOR = "=";
    private static final String LIKE_OPERATOR = "LIKE";
    private static final String ISCHILDNODE_OPERATOR = "ISCHILDNODE";
    private final SearchParameters parameters;
    private final StringBuilder joins;
    private final List<Condition> conditions;
    private int nextSelectorId = 1;
    private static final Logger logger = LoggerFactory.getLogger(SearchQueryBuilder.class);

    public SearchQueryBuilder(SearchParameters parameters) {
        this.parameters = parameters;
        this.joins = new StringBuilder();
        this.conditions = Lists.newArrayList();
    }

    public Query build(Session session) throws RepositoryException {
        if (this.parameters.at != null && this.parameters.after != null) {
            throw new IllegalArgumentException("Cannot set both at and after conditions on a JCR query");
        }
        if (this.parameters.at != null && this.parameters.before != null) {
            throw new IllegalArgumentException("Cannot set both at and before conditions on a JCR query");
        }
        this.createJoinsAndConditions();
        QueryManager qm = session.getWorkspace().getQueryManager();
        ValueFactory valueFactory = session.getValueFactory();
        String q = this.constructQueryString();
        Query query = qm.createQuery(q, "JCR-SQL2");
        this.addBinds(valueFactory, query);
        this.addPagingInfo(query);
        logger.debug("Query built: {}", (Object)query.getStatement());
        return query;
    }

    private String constructQueryString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ci.* FROM ");
        builder.append("[");
        if (this.parameters.at == null && this.parameters.after == null && this.parameters.before == null) {
            builder.append("deployit:configurationItem");
        } else {
            builder.append("{http://www.jcp.org/jcr/nt/1.0}base");
        }
        builder.append("]  AS ci");
        builder.append(this.joins.toString());
        if (!this.conditions.isEmpty()) {
            builder.append(" WHERE ");
            builder.append(Joiner.on((String)" AND ").join((Iterable)Collections2.transform(this.conditions, (Function)new Function<Condition, String>(){

                public String apply(Condition input) {
                    return input.build();
                }
            })));
        }
        builder.append(" ORDER BY NAME(ci)");
        logger.debug("Built query: {}", (Object)builder.toString());
        return builder.toString();
    }

    private void addBinds(ValueFactory valueFactory, Query query) throws RepositoryException {
        for (Condition eachCondition : this.conditions) {
            if (eachCondition.parameter == null) continue;
            for (int i = 0; i < eachCondition.values.length; ++i) {
                Value v;
                Object eachValue = eachCondition.values[i];
                if (eachValue instanceof String) {
                    v = valueFactory.createValue((String)eachValue);
                } else if (eachValue instanceof Calendar) {
                    v = valueFactory.createValue((Calendar)eachValue);
                } else {
                    throw new IllegalArgumentException("Value of Condition is not a String or a Calendar but a " + eachValue.getClass().getName());
                }
                query.bindValue(eachCondition.parameter + i, v);
                logger.debug("Bound {} to {}", (Object)(eachCondition.parameter + i), (Object)v.getString());
            }
        }
    }

    void addPagingInfo(Query query) {
        if (this.parameters.resultsPerPage > 0L) {
            query.setLimit(this.parameters.resultsPerPage);
            query.setOffset(this.parameters.page * this.parameters.resultsPerPage);
        }
    }

    private void createJoinsAndConditions() {
        this.createConditionForParent();
        this.createConditionForId();
        this.createConditionForConfigurationItemTypeName();
        this.createConditionForVersions();
        this.createConditionForCreatingTaskId();
        this.createConditionsForProperties();
    }

    private void createConditionForConfigurationItemTypeName() {
        if (this.parameters.type != null) {
            ArrayList types = Lists.newArrayList();
            types.add(this.parameters.type.toString());
            for (Type subtype : DescriptorRegistry.getSubtypes((Type)this.parameters.type)) {
                types.add(subtype.toString());
            }
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$configuration.item.type", "_configurationItemTypeName", EQUALITY_OPERATOR, false, types.toArray(new String[types.size()])));
        }
    }

    private void createConditionForParent() {
        if (!Strings.nullToEmpty((String)this.parameters.parent).trim().isEmpty()) {
            if (this.parameters.at != null) {
                throw new IllegalArgumentException("Cannot combine fromPath and at search parameters");
            }
            String parent = Strings.nullToEmpty((String)this.parameters.parent);
            if (!parent.startsWith("/")) {
                parent = "/" + parent;
            }
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$id", null, ISCHILDNODE_OPERATOR, parent));
        }
    }

    private void createConditionForId() {
        if (!Strings.nullToEmpty((String)this.parameters.id).trim().isEmpty()) {
            if (this.parameters.id.contains("%")) {
                this.conditions.add(Condition.imatch(CI_SELECTOR_NAME, "$id", "_id", this.parameters.id));
            } else {
                this.conditions.add(Condition.match(CI_SELECTOR_NAME, "$id", "_id", this.parameters.id));
            }
        }
    }

    private void createConditionForVersions() {
        if (this.parameters.at != null) {
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$lastModified", "_at", "<=", this.parameters.at));
        }
        if (this.parameters.after != null) {
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$lastModified", "_after", ">", this.parameters.after));
        }
        if (this.parameters.before != null) {
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$lastModified", "_before", "<=", this.parameters.before));
        }
    }

    private void createConditionForCreatingTaskId() {
        if (this.parameters.creatingTaskId != null) {
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$creatingTaskId", "_creatingTaskId", EQUALITY_OPERATOR, this.parameters.creatingTaskId));
        }
    }

    private void createConditionsForProperties() {
        for (Map.Entry<String, String> entry : this.parameters.properties.entrySet()) {
            this.createConditionForProperty(entry);
        }
    }

    protected void createConditionForProperty(Map.Entry<String, String> entry) {
        PropertyDescriptor propertyDescriptor;
        Descriptor descriptor;
        if (this.parameters.type != null && (descriptor = DescriptorRegistry.getDescriptor((Type)this.parameters.type)) != null && (propertyDescriptor = descriptor.getPropertyDescriptor(entry.getKey())) != null) {
            if (propertyDescriptor.getKind() == PropertyKind.CI) {
                String selectorName = "referenced" + this.nextSelectorId;
                this.joins.append(" INNER JOIN [deployit:configurationItem] AS " + selectorName + " ON " + CI_SELECTOR_NAME + ".[" + entry.getKey() + "] = " + selectorName + ".[jcr:uuid]");
                this.conditions.add(Condition.match(selectorName, "$id", entry.getKey(), entry.getValue()));
                ++this.nextSelectorId;
                return;
            }
            if (propertyDescriptor.getKind() == PropertyKind.SET_OF_CI) {
                throw new IllegalArgumentException("Cannot query property " + propertyDescriptor + " because it is of type SET_OF_CIS");
            }
        }
        this.conditions.add(Condition.match(CI_SELECTOR_NAME, entry.getKey(), entry.getKey(), entry.getValue()));
    }

    private static class Condition {
        String selector;
        String field;
        String operator;
        String parameter;
        Object[] values;
        boolean caseInsensitive;
        private static final String CASE_SENSITIVE = "%s.[%s] %s $%s";
        private static final String CASE_INSENSITIVE = "LOWER(%s.[%s]) %s $%s";
        private static final String ISCHILDNODE_FORMAT = "ISCHILDNODE(%s, ['%s'])";

        private Condition() {
        }

        String build() {
            StringBuilder conditionString = new StringBuilder();
            conditionString.append("(");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    conditionString.append(" OR ");
                }
                if (this.operator.equals(SearchQueryBuilder.ISCHILDNODE_OPERATOR)) {
                    conditionString.append(String.format(ISCHILDNODE_FORMAT, this.selector, this.values[i]));
                    continue;
                }
                conditionString.append(String.format(this.caseInsensitive ? CASE_INSENSITIVE : CASE_SENSITIVE, this.selector, this.field, this.operator, this.parameter + i));
            }
            conditionString.append(")");
            return conditionString.toString();
        }

        static Condition match(String selector, String field, String parameter, String value) {
            return Condition.match(selector, field, parameter, value, false);
        }

        static Condition imatch(String selector, String field, String parameter, String value) {
            return Condition.match(selector, field, parameter, value.toLowerCase(), true);
        }

        private static Condition match(String selector, String field, String parameter, String value, boolean caseInsensitive) {
            String operator = value.contains("%") ? SearchQueryBuilder.LIKE_OPERATOR : SearchQueryBuilder.EQUALITY_OPERATOR;
            return Condition.from(selector, field, parameter, operator, caseInsensitive, value);
        }

        static Condition from(String selector, String field, String parameter, String operator, Object value) {
            return Condition.from(selector, field, parameter, operator, false, value);
        }

        static Condition from(String selector, String field, String parameter, String operator, boolean caseInsensitive, Object ... values) {
            Condition t = new Condition();
            t.selector = selector;
            t.field = field;
            t.parameter = parameter;
            t.operator = operator;
            t.caseInsensitive = caseInsensitive;
            t.values = values;
            return t;
        }
    }
}

