/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapContextFactory
implements InitialContextFactory {
    private static final String SUN_ICF_FQCN = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String IBM_ICF_FQCN = "com.ibm.jndi.LDAPCtxFactory";
    private static final String BEA_ICF_FQCN = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String ICF_FQCN;
    private static final Logger logger;
    private InitialContextFactory factory = (InitialContextFactory)Class.forName(ICF_FQCN).newInstance();

    private static boolean tryFactory(String fqcn) {
        try {
            Class.forName(fqcn);
            logger.trace("Found LdapContextFactory: {}", (Object)fqcn);
            return true;
        }
        catch (ClassNotFoundException e) {
            logger.debug("Couldn't find LdapContextFactory: {}", (Object)fqcn);
            return false;
        }
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        return this.factory.getInitialContext(environment);
    }

    static {
        logger = LoggerFactory.getLogger(LdapContextFactory.class);
        ICF_FQCN = LdapContextFactory.tryFactory("com.sun.jndi.ldap.LdapCtxFactory") ? "com.sun.jndi.ldap.LdapCtxFactory" : (LdapContextFactory.tryFactory(IBM_ICF_FQCN) ? IBM_ICF_FQCN : (LdapContextFactory.tryFactory("com.sun.jndi.ldap.LdapCtxFactory") ? "com.sun.jndi.ldap.LdapCtxFactory" : "unknown"));
    }
}

