/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.UsernameAndPasswordCredentials;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityTemplate {
    public static <T> T executeAsAdmin(SecurityCallback<T> callback) {
        return SecurityTemplate.executeAs("admin", "admin", callback);
    }

    public static <T> T executeAs(String username, String password, final JcrTemplate jcrTemplate, final JcrCallback<T> callback) {
        return SecurityTemplate.executeAs(username, password, new SecurityCallback<T>(){

            @Override
            public T doAs() {
                return jcrTemplate.execute(callback);
            }
        });
    }

    public static <T> T executeAs(UsernameAndPasswordCredentials credentials, SecurityCallback<T> callback) {
        return SecurityTemplate.executeAs(credentials.getUsername(), credentials.getPassword(), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeAs(String username, String password, SecurityCallback<T> callback) {
        Authentication origAuthentication = SecurityTemplate.setCredentials(username, password);
        try {
            T t = callback.doAs();
            return t;
        }
        finally {
            SecurityTemplate.restoreAuthentication(origAuthentication);
        }
    }

    public static Authentication setCredentials(String username, String password) {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication origAuthentication = context.getAuthentication();
        context.setAuthentication((Authentication)new UsernameAndPasswordCredentials(username, password));
        return origAuthentication;
    }

    public static void restoreAuthentication(Authentication origAuthentication) {
        SecurityContextHolder.getContext().setAuthentication(origAuthentication);
    }
}

