/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.permission;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.security.AccessControlService;
import com.xebialabs.deployit.security.JcrAccessControlEntry;
import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivilegesHelper {
    private static final Logger logger = LoggerFactory.getLogger(PermissionHandler.class);

    static void grantPrivileges(List<String> privileges, String principal, String node, boolean transitive) {
        AccessControlService accessControlService = SecurityServiceLocator.getAccessControlService();
        Collection<JcrAccessControlEntry> acls = accessControlService.getAccessControlEntries(node);
        JcrAccessControlEntry found = PrivilegesHelper.findAclForPrincipal(principal, acls, true, transitive);
        if (found == null) {
            found = new JcrAccessControlEntry(principal, true, privileges, transitive);
            acls.add(found);
        } else {
            found.getPrivileges().addAll(privileges);
        }
        accessControlService.setAccessControlEntries(node, (JcrAccessControlEntry[])Iterables.toArray(acls, JcrAccessControlEntry.class));
    }

    static void denyPrivileges(List<String> privileges, String principal, String node, boolean transitive) {
        AccessControlService accessControlService = SecurityServiceLocator.getAccessControlService();
        Collection<JcrAccessControlEntry> acls = accessControlService.getAccessControlEntries(node);
        JcrAccessControlEntry found = PrivilegesHelper.findAclForPrincipal(principal, acls, false, transitive);
        if (found == null) {
            found = new JcrAccessControlEntry(principal, false, privileges, transitive);
            acls.add(found);
        } else {
            found.getPrivileges().addAll(privileges);
        }
        accessControlService.setAccessControlEntries(node, (JcrAccessControlEntry[])Iterables.toArray(acls, JcrAccessControlEntry.class));
    }

    static void revokePrivileges(List<String> privileges, String principal, String node, boolean transitive) {
        AccessControlService accessControlService = SecurityServiceLocator.getAccessControlService();
        Collection<JcrAccessControlEntry> acls = accessControlService.getAccessControlEntries(node);
        Collection<JcrAccessControlEntry> found = PrivilegesHelper.findAclsForPrincipal(principal, acls);
        for (JcrAccessControlEntry entry : found) {
            if (entry.isTransitive() != transitive) continue;
            entry.getPrivileges().removeAll(privileges);
        }
        accessControlService.setAccessControlEntries(node, (JcrAccessControlEntry[])Iterables.toArray(acls, JcrAccessControlEntry.class));
    }

    static JcrAccessControlEntry findAclForPrincipal(String principal, Collection<JcrAccessControlEntry> acls, boolean granted, boolean transitive) {
        Collection<JcrAccessControlEntry> aclsForPrincipal = PrivilegesHelper.findAclsForPrincipal(principal, acls);
        JcrAccessControlEntry found = null;
        for (JcrAccessControlEntry jcrAccessControlEntry : aclsForPrincipal) {
            if (jcrAccessControlEntry.isAllow() != granted || jcrAccessControlEntry.isTransitive() != transitive) continue;
            found = jcrAccessControlEntry;
            break;
        }
        return found;
    }

    static Collection<JcrAccessControlEntry> findAclsForPrincipal(final String principal, Collection<JcrAccessControlEntry> acls) {
        Collection aclsForPrincipal = Collections2.filter(acls, (Predicate)new Predicate<JcrAccessControlEntry>(){

            public boolean apply(JcrAccessControlEntry input) {
                return input.getPrincipalName().equals(principal);
            }
        });
        logger.debug("Found [{}] acls for principal {}", (Object)aclsForPrincipal, (Object)principal);
        return aclsForPrincipal;
    }
}

