/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.python;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionExecutionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionStep;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.python.PythonStep;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonInspectionStep
extends PythonStep<InspectionExecutionContext>
implements InspectionStep {
    private static final String defaultEncoding = "UTF-8";
    protected ConfigurationItem inspectedItem;
    protected Descriptor inspectedItemDescriptor;
    public static final String INSPECTED_PROPERTY_PRELUDE = "INSPECTED:";
    public static final String DISCOVERED_ITEM_PRELUDE = "DISCOVERED:";
    private static Logger logger = LoggerFactory.getLogger(PythonInspectionStep.class);

    public PythonInspectionStep(ConfigurationItem inspectedItem, PythonManagingContainer container, String scriptPath, Map<String, Object> pythonVars, String description) {
        super(container, scriptPath, pythonVars, description);
        this.inspectedItem = inspectedItem;
        this.inspectedItemDescriptor = DescriptorRegistry.getDescriptor((Type)inspectedItem.getType());
    }

    public Step.Result execute(final InspectionExecutionContext ctx) throws Exception {
        Step.Result result = this.doExecute((ExecutionContext)new InspectionExecutionContext(){

            public void logOutput(String output) {
                if (PythonInspectionStep.this.handleOutputLine(output, ctx)) {
                    logger.trace("Handled inspection protocol line {}", (Object)output);
                } else {
                    ctx.logOutput(output);
                }
            }

            public void logError(String error) {
                ctx.logError(error);
            }

            public void logError(String error, Throwable t) {
                ctx.logError(error, t);
            }

            public Object getAttribute(String name) {
                return ctx.getAttribute(name);
            }

            public void setAttribute(String name, Object object) {
                ctx.setAttribute(name, object);
            }

            public void discovered(ConfigurationItem item) {
                ctx.discovered(item);
            }
        });
        return result;
    }

    protected boolean handleOutputLine(String line, InspectionExecutionContext ctx) {
        int posOfEqualsSign = line.indexOf(61);
        if (posOfEqualsSign < 0) {
            return false;
        }
        try {
            if (line.startsWith(INSPECTED_PROPERTY_PRELUDE)) {
                String name = URLDecoder.decode(line.substring(INSPECTED_PROPERTY_PRELUDE.length(), posOfEqualsSign), defaultEncoding);
                String value = line.substring(posOfEqualsSign + 1);
                return this.handleInspectedProperty(name, value, ctx);
            }
            if (line.startsWith(DISCOVERED_ITEM_PRELUDE)) {
                String id = URLDecoder.decode(line.substring(DISCOVERED_ITEM_PRELUDE.length(), posOfEqualsSign), defaultEncoding);
                String typeName = line.substring(posOfEqualsSign + 1);
                return this.handleDiscoveredItem(id, typeName, ctx);
            }
        }
        catch (UnsupportedEncodingException encodingException) {
            logger.debug("Unsupported encoding exception was encountered while parsing inspected and / or discovered items");
            return false;
        }
        return false;
    }

    private boolean handleInspectedProperty(String name, String value, InspectionExecutionContext ctx) throws UnsupportedEncodingException {
        PropertyDescriptor pd = this.inspectedItemDescriptor.getPropertyDescriptor(name);
        if (pd == null) {
            ctx.logError("Inspected unknown property " + name);
            return false;
        }
        if (pd.getKind() == PropertyKind.SET_OF_CI) {
            HashSet refs = Sets.newHashSet();
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)pd.getReferencedType());
            for (String id : value.split(",")) {
                ConfigurationItem ref = descriptor.newInstance();
                ref.setId(URLDecoder.decode(id, defaultEncoding));
                refs.add(ref);
            }
            pd.set(this.inspectedItem, (Object)refs);
        } else if (pd.getKind() == PropertyKind.SET_OF_STRING) {
            HashSet<String> stringProperties = new HashSet<String>();
            for (String property : value.split(",")) {
                stringProperties.add(URLDecoder.decode(property, defaultEncoding));
            }
            pd.set(this.inspectedItem, stringProperties);
        } else if (pd.getKind() == PropertyKind.MAP_STRING_STRING) {
            HashMap<String, String> mapProperties = new HashMap<String, String>();
            for (String property : value.split(",")) {
                if (!property.contains(":")) continue;
                String[] keyValue = property.split(":");
                mapProperties.put(URLDecoder.decode(keyValue[0], defaultEncoding), URLDecoder.decode(keyValue[1], defaultEncoding));
            }
            pd.set(this.inspectedItem, mapProperties);
        } else {
            pd.set(this.inspectedItem, (Object)URLDecoder.decode(value, defaultEncoding));
        }
        logger.debug("Inspected property {} with value {}", (Object)name, (Object)value);
        return true;
    }

    private boolean handleDiscoveredItem(String id, String typeName, InspectionExecutionContext ctx) throws UnsupportedEncodingException {
        Type type = Type.valueOf((String)URLDecoder.decode(typeName, defaultEncoding));
        if (!DescriptorRegistry.exists((Type)type)) {
            ctx.logError("Discovered item " + id + " of unknown type " + type);
            return false;
        }
        Descriptor d = DescriptorRegistry.getDescriptor((Type)type);
        ConfigurationItem discoveredItem = d.newInstance();
        discoveredItem.setId(id);
        for (PropertyDescriptor pd : d.getPropertyDescriptors()) {
            if (!this.isReferenceToParent(pd)) continue;
            pd.set(discoveredItem, (Object)this.inspectedItem);
        }
        ctx.discovered(discoveredItem);
        logger.debug("Discovered item {} with type {}", (Object)id, (Object)type);
        return true;
    }

    protected boolean isReferenceToParent(PropertyDescriptor pd) {
        return pd.getKind() == PropertyKind.CI && pd.isAsContainment() && this.inspectedItemDescriptor.isAssignableTo(pd.getReferencedType());
    }
}

