/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.validation;

import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Pattern;

@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="regex")
@Target(value={ElementType.FIELD})
public @interface Regex {
    public String pattern();

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<String> {
        private String pattern;

        @Override
        public void validate(String value, ValidationContext context) {
            if (value != null && !Pattern.compile(this.pattern).matcher(value).matches()) {
                context.error("Value %s did not conform to pattern %s", value, this.pattern);
            }
        }
    }
}

