/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key.pbe.swing;

import de.schlichtherle.truezip.key.pbe.SafePbeParameters;
import de.schlichtherle.truezip.key.pbe.swing.AuthenticationPanel;
import de.schlichtherle.truezip.key.pbe.swing.KeyPanel;
import de.schlichtherle.truezip.key.pbe.swing.SwingSafePbeParametersView;
import de.schlichtherle.truezip.swing.EnhancedPanel;
import de.schlichtherle.truezip.swing.PanelEvent;
import de.schlichtherle.truezip.swing.PanelListener;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

@DefaultAnnotation(value={NonNull.class})
public class ReadKeyPanel
extends KeyPanel {
    private static final long serialVersionUID = 984673974236493651L;
    private static final String CLASS_NAME = ReadKeyPanel.class.getName();
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    private final Color defaultForeground;
    AuthenticationPanel authenticationPanel;
    private final JCheckBox changeKey = new JCheckBox();
    JLabel error;
    JPasswordField passwdField;
    JLabel passwdLabel;
    EnhancedPanel passwdPanel;
    JTextPane resource;

    public ReadKeyPanel() {
        this.initComponents();
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ReadKeyPanel.this.setError(null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ReadKeyPanel.this.setError(null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ReadKeyPanel.this.setError(null);
            }
        };
        this.passwdField.getDocument().addDocumentListener(dl);
        this.authenticationPanel.getKeyFileDocument().addDocumentListener(dl);
        this.defaultForeground = this.resource.getForeground();
    }

    @Override
    public URI getResource() {
        return URI.create(this.resource.getText());
    }

    @Override
    public void setResource(URI resource) {
        URI lastResource = SwingSafePbeParametersView.lastResource;
        if (!lastResource.equals(resource) && !lastResource.equals(SwingSafePbeParametersView.INITIAL_RESOURCE)) {
            this.resource.setForeground(Color.RED);
        } else {
            this.resource.setForeground(this.defaultForeground);
        }
        this.resource.setText(resource.toString());
        SwingSafePbeParametersView.lastResource = resource;
    }

    @Override
    public String getError() {
        String error = this.error.getText();
        return error.isEmpty() ? null : error;
    }

    @Override
    public void setError(String error) {
        this.error.setText(error);
    }

    @Override
    boolean updateParam(SafePbeParameters<?, ?> param) {
        switch (this.authenticationPanel.getAuthenticationMethod()) {
            case 0: {
                char[] passwd = this.passwdField.getPassword();
                param.setPassword(passwd);
                Arrays.fill(passwd, '\u0000');
                return true;
            }
            case 1: {
                File keyFile = this.authenticationPanel.getKeyFile();
                try {
                    byte[] key = SwingSafePbeParametersView.readKeyFile(keyFile);
                    param.setKeyFileBytes(key);
                    Arrays.fill(key, (byte)0);
                    return true;
                }
                catch (EOFException ex) {
                    this.setError(resources.getString("keyFile.eofException"));
                    return false;
                }
                catch (FileNotFoundException ex) {
                    this.setError(resources.getString("keyFile.fileNotFoundException"));
                    return false;
                }
                catch (IOException ex) {
                    this.setError(resources.getString("keyFile.ioException"));
                    return false;
                }
            }
        }
        throw new AssertionError((Object)"Unsupported authentication method!");
    }

    public boolean isChangeKeySelected() {
        return this.changeKey.isSelected();
    }

    public void setChangeKeySelected(boolean changeKeySelected) {
        this.changeKey.setSelected(changeKeySelected);
    }

    private void initComponents() {
        this.passwdPanel = new EnhancedPanel();
        this.passwdLabel = new JLabel();
        this.passwdField = new JPasswordField();
        JLabel prompt = new JLabel();
        this.resource = new JTextPane();
        this.authenticationPanel = new AuthenticationPanel();
        this.error = new JLabel();
        this.passwdPanel.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent evt) {
                ReadKeyPanel.this.passwdPanelAncestorWindowShown(evt);
            }

            public void ancestorWindowHidden(PanelEvent evt) {
            }
        });
        this.passwdPanel.setLayout((LayoutManager)new GridBagLayout());
        this.passwdLabel.setDisplayedMnemonic(resources.getString("passwd").charAt(0));
        this.passwdLabel.setLabelFor(this.passwdField);
        this.passwdLabel.setText(resources.getString("passwd"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.passwdPanel.add((Component)this.passwdLabel, (Object)gridBagConstraints);
        this.passwdField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.passwdPanel.add((Component)this.passwdField, (Object)gridBagConstraints);
        this.setLayout(new GridBagLayout());
        prompt.setLabelFor(this.resource);
        prompt.setText(resources.getString("prompt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add(prompt, gridBagConstraints);
        this.resource.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.resource.setEditable(false);
        this.resource.setFont(this.resource.getFont().deriveFont(this.resource.getFont().getStyle() | 1));
        this.resource.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add(this.resource, gridBagConstraints);
        this.authenticationPanel.setPasswdPanel((JPanel)this.passwdPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add(this.authenticationPanel, gridBagConstraints);
        this.changeKey.setText(resources.getString("changeKey"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add(this.changeKey, gridBagConstraints);
        this.error.setForeground(Color.red);
        this.error.setName("error");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add(this.error, gridBagConstraints);
    }

    private void passwdPanelAncestorWindowShown(PanelEvent evt) {
        final Window window = evt.getSource().getAncestorWindow();
        window.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                window.removeWindowFocusListener(this);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ReadKeyPanel.this.passwdField.requestFocusInWindow()) {
                            ReadKeyPanel.this.passwdField.selectAll();
                        }
                    }
                });
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
    }
}

