/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.dto;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.core.api.dto.AbstractDTO;
import com.xebialabs.deployit.core.api.jaxb.PrincipalPermissionEntry;
import com.xebialabs.deployit.core.api.jaxb.PrincipalPermissionList;
import com.xebialabs.deployit.core.api.jaxb.PrincipalPermissionsMapAdapter;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="security-settings")
@XmlSeeAlso(value={PrincipalPermissionList.class, PrincipalPermissionEntry.class})
public class PrincipalPermissions
extends AbstractDTO {
    @XmlAttribute
    private String username;
    @XmlElementRef
    @XmlJavaTypeAdapter(value=PrincipalPermissionsMapAdapter.class)
    private Map<String, Set<String>> principalPermissions = Maps.newTreeMap();

    public PrincipalPermissions() {
    }

    public PrincipalPermissions(String userName, Map<String, Set<String>> principalPermissions) {
        this.username = userName;
        this.principalPermissions = principalPermissions;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String userName) {
        this.username = userName;
    }

    public boolean hasPermissions() {
        return !this.principalPermissions.isEmpty();
    }

    public boolean hasPermission(String permission) {
        return this.principalPermissions.containsKey(permission);
    }

    public boolean hasPermission(String permission, String target) {
        return this.principalPermissions.containsKey(permission) && (this.principalPermissions.get(permission).contains(target) || this.principalPermissions.get(permission).contains(""));
    }

    public boolean isPermissionGlobal(String permission) {
        return this.principalPermissions.containsKey(permission) && this.principalPermissions.get(permission).contains("");
    }

    public boolean setPermissions(String permission, Set<String> targets) {
        boolean validMapping;
        boolean bl = validMapping = permission != null && targets != null;
        if (validMapping) {
            this.principalPermissions.put(permission, targets);
        }
        return validMapping && this.principalPermissions.containsKey(permission);
    }

    public Set<String> getPermissions() {
        return this.principalPermissions.keySet();
    }

    public Set<String> getPermissionTargets(String permission) {
        return this.principalPermissions.get(permission);
    }

    public Map<String, Set<String>> getValues() {
        return this.principalPermissions;
    }

    public Set<Map.Entry<String, Set<String>>> getValuesAsSet() {
        return this.principalPermissions.entrySet();
    }

    public Map<String, Set<String>> asTargetsWithPermissions() {
        return this.swapPermissionsTargetsMap(this.principalPermissions.entrySet());
    }

    @Override
    public String toString() {
        StringBuilder permissionString = new StringBuilder();
        if (this.principalPermissions == null || this.principalPermissions.isEmpty()) {
            permissionString.append("There are no permissions set for the requested user, or the requested user doesn't exist!\n");
        } else {
            for (String permissionTarget : this.principalPermissions.keySet()) {
                if (this.principalPermissions.get(permissionTarget).contains("")) {
                    permissionString.append(String.format("\nGranted global permission '%s'\n", permissionTarget));
                    continue;
                }
                permissionString.append(String.format("\nGranted permission '%s' on:\n", permissionTarget));
                for (String value : this.principalPermissions.get(permissionTarget)) {
                    permissionString.append(String.format("\t %s\n", value));
                }
                permissionString.append("\n");
            }
        }
        return permissionString.toString();
    }

    private Map<String, Set<String>> swapPermissionsTargetsMap(Set<Map.Entry<String, Set<String>>> permissionsSet) {
        TreeMap targets = Maps.newTreeMap();
        for (Map.Entry<String, Set<String>> permission : permissionsSet) {
            for (String target : permission.getValue()) {
                if (!targets.containsKey(target)) {
                    targets.put(target, Sets.newTreeSet());
                }
                ((Set)targets.get(target)).add(permission.getKey());
            }
        }
        return targets;
    }
}

