/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.crypto.param.AesKeyStrength;
import de.schlichtherle.truezip.zip.ExtraField;
import de.schlichtherle.truezip.zip.LittleEndian;
import de.schlichtherle.truezip.zip.UShort;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class WinZipAesEntryExtraField
extends ExtraField {
    private static final int DATA_SIZE = 7;
    private static final int VENDOR_ID = 17729;
    private static final AesKeyStrength[] KEY_STRENGTHS = AesKeyStrength.values();
    static final int VV_AE_1 = 1;
    static final int VV_AE_2 = 2;
    private short vendorVersion = 1;
    private byte encryptionStrength = WinZipAesEntryExtraField.encryptionStrength(AesKeyStrength.BITS_128);
    private short method;

    WinZipAesEntryExtraField() {
    }

    private static byte encryptionStrength(AesKeyStrength keyStrength) {
        return (byte)(keyStrength.ordinal() + 1);
    }

    private static AesKeyStrength keyStrength(int encryptionStrength) {
        return KEY_STRENGTHS[encryptionStrength - 1 & 0xFF];
    }

    @Override
    int getHeaderId() {
        return 39169;
    }

    @Override
    int getDataSize() {
        return 7;
    }

    int getVendorVersion() {
        return this.vendorVersion & 0xFFFF;
    }

    void setVendorVersion(int vendorVersion) {
        if (vendorVersion < 1 || 2 < vendorVersion) {
            throw new IllegalArgumentException("" + vendorVersion);
        }
        this.vendorVersion = (short)vendorVersion;
    }

    int getVendorId() {
        return 17729;
    }

    AesKeyStrength getKeyStrength() {
        return WinZipAesEntryExtraField.keyStrength(this.encryptionStrength);
    }

    void setKeyStrength(AesKeyStrength keyStrength) {
        this.encryptionStrength = WinZipAesEntryExtraField.encryptionStrength(keyStrength);
    }

    int getMethod() {
        return this.method & 0xFFFF;
    }

    void setMethod(int compressionMethod) {
        assert (UShort.check(compressionMethod));
        this.method = (short)compressionMethod;
    }

    @Override
    void readFrom(byte[] src, int off, int size) {
        if (7 != size) {
            throw new IllegalArgumentException();
        }
        this.setVendorVersion(LittleEndian.readUShort(src, off));
        short vendorId = (short)LittleEndian.readUShort(src, off += 2);
        off += 2;
        if (17729 != vendorId) {
            throw new IllegalArgumentException();
        }
        this.setKeyStrength(WinZipAesEntryExtraField.keyStrength(src[off]));
        this.setMethod(LittleEndian.readUShort(src, ++off));
    }

    @Override
    void writeTo(byte[] dst, int off) {
        LittleEndian.writeShort(this.vendorVersion, dst, off);
        LittleEndian.writeShort(17729, dst, off += 2);
        dst[off += 2] = this.encryptionStrength;
        LittleEndian.writeShort(this.method, dst, ++off);
    }
}

