/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.cli.Cli;
import com.xebialabs.deployit.cli.CliOptions;
import com.xebialabs.deployit.cli.ScriptEngineBuilder;
import com.xebialabs.deployit.cli.help.HelpScanner;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import jline.TerminalFactory;
import jline.console.ConsoleReader;

public class Interpreter {
    private ScriptEngine scriptEngine;
    private CliOptions options;
    private ScriptContext scriptContext;
    private ConsoleReader consoleReader;

    public Interpreter(ConsoleReader consoleReader, ScriptEngineBuilder scriptEngineBuilder, CliOptions cliOptions) {
        this.consoleReader = consoleReader;
        this.scriptEngine = scriptEngineBuilder.build(cliOptions);
        this.options = cliOptions;
        this.scriptContext = new SimpleScriptContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interpret() throws Exception {
        block9: {
            try {
                if (this.options.interpretSourceFile()) {
                    this.scriptContext.setAttribute("javax.script.filename", this.options.getSourceFileName(), 100);
                    FileReader fileReader = new FileReader(this.options.getSourceFileName());
                    try {
                        this.evaluate(fileReader);
                        break block9;
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)fileReader);
                        TerminalFactory.get().restore();
                    }
                }
                try {
                    this.advancedRepl(this.consoleReader);
                }
                catch (Exception exception) {
                    throw new IllegalStateException("The REPL gave an exception!", exception);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("File " + this.options.getSourceFileName() + " could not be read, reason:" + fileNotFoundException.getMessage());
                TerminalFactory.get().restore();
                System.exit(1);
            }
            catch (ScriptException scriptException) {
                System.err.println("An error occurred while interpreting file " + this.options.getSourceFileName() + ", reason:" + scriptException.getMessage());
                TerminalFactory.get().restore();
                System.exit(1);
            }
        }
    }

    public Object evaluate(Reader reader) throws ScriptException {
        return this.scriptEngine.eval(reader, this.scriptContext);
    }

    Object evaluate(String string) throws ScriptException {
        if (string == null) {
            return null;
        }
        return this.scriptEngine.eval(string, this.scriptContext);
    }

    private void advancedRepl(ConsoleReader consoleReader) throws Exception {
        while (true) {
            String string;
            String string2;
            String string3 = string2 = (string = consoleReader.readLine(this.getPrompt())) != null ? string.trim() : null;
            if (string2 == null || string2.startsWith("quit") || string2.startsWith("exit")) break;
            if (string2.startsWith("help")) {
                HelpScanner.printHelp();
                continue;
            }
            try {
                Object object = this.evaluate(string);
                if (object instanceof String) {
                    System.out.println((String)object);
                    continue;
                }
                if (object == null) continue;
                System.out.println("Ok [returned an object of type " + object.getClass().getSimpleName() + "]");
            }
            catch (ScriptException scriptException) {
                System.err.println("Exception: " + scriptException);
            }
        }
        this.exit();
    }

    protected void exit() throws Exception {
        System.out.println("Bye bye!");
        TerminalFactory.get().restore();
    }

    String getPrompt() {
        String string = "deployit > ";
        String string2 = Cli.getAuthentication().username;
        if (string2 != null) {
            string = string2 + " > ";
        }
        return string;
    }
}

