/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_1_0;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dt.GridDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeCoverage {
    private Logger logger = LoggerFactory.getLogger(DescribeCoverage.class);
    protected static final Namespace wcsNS = Namespace.getNamespace((String)"http://www.opengis.net/wcs/1.1");
    protected static final Namespace owcsNS = Namespace.getNamespace((String)"owcs", (String)"http://www.opengis.net/wcs/1.1/ows");
    protected static final Namespace owsNS = Namespace.getNamespace((String)"ows", (String)"http://www.opengis.net/ows");
    protected static final Namespace xlinkNS = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
    private URI serverURI;
    private List<String> identifiers;
    private String version = "1.1.0";
    private GridDataset dataset;
    private Document describeCoverageDoc;

    public DescribeCoverage(URI serverURI, List<String> identifiers, GridDataset dataset) {
        this.serverURI = serverURI;
        this.identifiers = identifiers;
        this.dataset = dataset;
        if (this.serverURI == null) {
            throw new IllegalArgumentException("Non-null server URI required.");
        }
        if (this.identifiers == null) {
            throw new IllegalArgumentException("Non-null identifier list required.");
        }
        if (this.identifiers.size() < 1) {
            throw new IllegalArgumentException("Identifier list must contain at least one ID <" + this.identifiers.size() + ">.");
        }
        if (this.dataset == null) {
            throw new IllegalArgumentException("Non-null dataset required.");
        }
    }

    public Document getDescribeCoverageDoc() {
        if (this.describeCoverageDoc == null) {
            this.describeCoverageDoc = this.generateDescribeCoverageDoc();
        }
        return this.describeCoverageDoc;
    }

    public void writeDescribeCoverageDoc(PrintWriter pw) throws IOException {
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        xmlOutputter.output(this.getDescribeCoverageDoc(), (Writer)pw);
    }

    public Document generateDescribeCoverageDoc() {
        Element coverageDescriptionsElem = new Element("CoverageDescriptions", wcsNS);
        coverageDescriptionsElem.addNamespaceDeclaration(owcsNS);
        coverageDescriptionsElem.addNamespaceDeclaration(owsNS);
        coverageDescriptionsElem.addNamespaceDeclaration(xlinkNS);
        for (String curId : this.identifiers) {
            coverageDescriptionsElem.addContent((Content)this.genCovDescrip(curId));
        }
        return new Document(coverageDescriptionsElem);
    }

    public Element genCovDescrip(String covId) {
        Element covDescripElem = new Element("CoverageDescription", wcsNS);
        covDescripElem.addContent((Content)new Element("Identifier", wcsNS).addContent(covId));
        return covDescripElem;
    }
}

