/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jackrabbit.core.query.lucene.EmptyTermDocs;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermDocsCache {
    private static final Logger log = LoggerFactory.getLogger(TermDocsCache.class);
    private static final int CACHE_SIZE = 10;
    private final IndexReader reader;
    private final String field;
    private final Map<String, String> unknownValues = Collections.synchronizedMap(new LinkedHashMap<String, String>(){
        private static final long serialVersionUID = 1443679637070403838L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 100;
        }
    });
    private final Map<String, CacheEntry> cache = new LinkedHashMap<String, CacheEntry>();

    public TermDocsCache(IndexReader reader, String field) {
        this.reader = reader;
        this.field = field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TermDocs termDocs(Term t) throws IOException {
        CacheEntry entry;
        if (t.field() != this.field) {
            return this.reader.termDocs(t);
        }
        String text = t.text();
        if (this.unknownValues.get(text) != null) {
            log.debug("EmptyTermDocs({},{})", (Object)this.field, (Object)text);
            return EmptyTermDocs.INSTANCE;
        }
        Map<String, CacheEntry> map = this.cache;
        synchronized (map) {
            entry = this.cache.get(text);
            if (entry == null) {
                if (this.cache.size() >= 10) {
                    Object[] entries = this.cache.values().toArray(new CacheEntry[this.cache.size()]);
                    Arrays.sort(entries);
                    int threshold = ((CacheEntry)entries[5]).numAccessed;
                    Iterator<Map.Entry<String, CacheEntry>> it = this.cache.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<String, CacheEntry> e = it.next();
                        if (e.getValue().numAccessed <= threshold) {
                            it.remove();
                            continue;
                        }
                        CacheEntry ce = e.getValue();
                        ce.numAccessed = (int)Math.sqrt(ce.numAccessed);
                    }
                }
                entry = new CacheEntry();
                this.cache.put(text, entry);
            } else {
                entry.numAccessed++;
            }
        }
        if (entry.numAccessed < 10) {
            if (log.isDebugEnabled()) {
                log.debug("#{} TermDocs({},{})", new Object[]{entry.numAccessed, this.field, text});
            }
            return this.reader.termDocs(t);
        }
        if (entry.bits == null) {
            BitSet bits = null;
            TermDocs tDocs = this.reader.termDocs(t);
            try {
                while (tDocs.next()) {
                    if (bits == null) {
                        bits = new BitSet(this.reader.maxDoc());
                    }
                    bits.set(tDocs.doc());
                }
            }
            finally {
                tDocs.close();
            }
            if (bits != null) {
                entry.bits = bits;
            }
        }
        if (entry.bits == null) {
            this.unknownValues.put(text, text);
            return EmptyTermDocs.INSTANCE;
        }
        if (log.isDebugEnabled()) {
            log.debug("CachedTermDocs({},{},{}/{})", new Object[]{this.field, text, entry.bits.cardinality(), this.reader.maxDoc()});
        }
        return new CachedTermDocs(entry.bits);
    }

    private static final class CacheEntry
    implements Comparable {
        private volatile int numAccessed = 1;
        private volatile BitSet bits;

        private CacheEntry() {
        }

        public int compareTo(Object o) {
            CacheEntry other = (CacheEntry)o;
            return this.numAccessed < other.numAccessed ? -1 : (this.numAccessed == other.numAccessed ? 0 : 1);
        }
    }

    private static final class CachedTermDocs
    implements TermDocs {
        private final BitSet docs;
        private int position = -1;
        private boolean moreDocs = true;

        public CachedTermDocs(BitSet docs) {
            this.docs = docs;
        }

        public void seek(Term term) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void seek(TermEnum termEnum) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int doc() {
            return this.position;
        }

        public int freq() {
            return 1;
        }

        public boolean next() throws IOException {
            if (this.moreDocs) {
                this.position = this.docs.nextSetBit(this.position + 1);
                this.moreDocs = this.position != -1;
            }
            return this.moreDocs;
        }

        public int read(int[] docs, int[] freqs) throws IOException {
            int count;
            for (count = 0; count < docs.length && this.next(); ++count) {
                docs[count] = this.doc();
                freqs[count] = 1;
            }
            return count;
        }

        public boolean skipTo(int target) throws IOException {
            if (this.moreDocs) {
                this.position = this.docs.nextSetBit(target);
                this.moreDocs = this.position != -1;
            }
            return this.moreDocs;
        }

        public void close() throws IOException {
        }
    }
}

