/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

class ReflectionUtils {
    ReflectionUtils() {
    }

    static Field searchField(Class<?> clazz, String string) {
        Class<?> clazz2 = clazz;
        while (!clazz2.equals(Object.class)) {
            try {
                return clazz2.getDeclaredField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                clazz2 = clazz2.getSuperclass();
            }
        }
        throw new IllegalArgumentException("Cannot find '" + string + "' field on " + clazz.getName());
    }

    static RuntimeException handleInvocationTargetException(InvocationTargetException invocationTargetException, String string) {
        Throwable throwable = invocationTargetException.getCause();
        if (throwable != null) {
            return new RuntimeException(string + "\n" + throwable.getMessage(), throwable);
        }
        return new RuntimeException(string, invocationTargetException);
    }

    static void setField(Object object, String string, Object object2) {
        Field field = ReflectionUtils.searchField(object.getClass(), string);
        field.setAccessible(true);
        ReflectionUtils.setField(object, field, object2);
    }

    static Object getField(Object object, Field field) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(String.format("Could not get field %s on %s.", field.getName(), object), illegalAccessException);
        }
    }

    static void setField(Object object, Field field, Object object2) {
        try {
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(String.format("Could not set field %s on %s to value %s.", field.getName(), object, object2), illegalAccessException);
        }
    }
}

